<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPayeeInfoRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetPayeeInfoRequest
 * @subpackage Structs
 */
class GetPayeeInfoRequest extends AbstractStructBase
{
    /**
     * The MethodID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MethodID;
    /**
     * The OrgID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrgID;
    /**
     * The PayeeDetail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPayeeDetail
     */
    public $PayeeDetail;
    /**
     * Constructor method for GetPayeeInfoRequest
     * @uses GetPayeeInfoRequest::setMethodID()
     * @uses GetPayeeInfoRequest::setOrgID()
     * @uses GetPayeeInfoRequest::setPayeeDetail()
     * @param string $methodID
     * @param string $orgID
     * @param \ArrayType\ArrayOfPayeeDetail $payeeDetail
     */
    public function __construct($methodID = null, $orgID = null, \ArrayType\ArrayOfPayeeDetail $payeeDetail = null)
    {
        $this
            ->setMethodID($methodID)
            ->setOrgID($orgID)
            ->setPayeeDetail($payeeDetail);
    }
    /**
     * Get MethodID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMethodID()
    {
        return isset($this->MethodID) ? $this->MethodID : null;
    }
    /**
     * Set MethodID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $methodID
     * @return \StructType\GetPayeeInfoRequest
     */
    public function setMethodID($methodID = null)
    {
        // validation for constraint: string
        if (!is_null($methodID) && !is_string($methodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($methodID)), __LINE__);
        }
        if (is_null($methodID) || (is_array($methodID) && empty($methodID))) {
            unset($this->MethodID);
        } else {
            $this->MethodID = $methodID;
        }
        return $this;
    }
    /**
     * Get OrgID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrgID()
    {
        return isset($this->OrgID) ? $this->OrgID : null;
    }
    /**
     * Set OrgID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orgID
     * @return \StructType\GetPayeeInfoRequest
     */
    public function setOrgID($orgID = null)
    {
        // validation for constraint: string
        if (!is_null($orgID) && !is_string($orgID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgID)), __LINE__);
        }
        if (is_null($orgID) || (is_array($orgID) && empty($orgID))) {
            unset($this->OrgID);
        } else {
            $this->OrgID = $orgID;
        }
        return $this;
    }
    /**
     * Get PayeeDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPayeeDetail|null
     */
    public function getPayeeDetail()
    {
        return isset($this->PayeeDetail) ? $this->PayeeDetail : null;
    }
    /**
     * Set PayeeDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPayeeDetail $payeeDetail
     * @return \StructType\GetPayeeInfoRequest
     */
    public function setPayeeDetail(\ArrayType\ArrayOfPayeeDetail $payeeDetail = null)
    {
        if (is_null($payeeDetail) || (is_array($payeeDetail) && empty($payeeDetail))) {
            unset($this->PayeeDetail);
        } else {
            $this->PayeeDetail = $payeeDetail;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPayeeInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
