<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfValidationDetails ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfValidationDetails
 * @subpackage Arrays
 */
class ArrayOfValidationDetails extends AbstractStructArrayBase
{
    /**
     * The ValidationDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ValidationDetails[]
     */
    public $ValidationDetails;
    /**
     * Constructor method for ArrayOfValidationDetails
     * @uses ArrayOfValidationDetails::setValidationDetails()
     * @param \StructType\ValidationDetails[] $validationDetails
     */
    public function __construct(array $validationDetails = array())
    {
        $this
            ->setValidationDetails($validationDetails);
    }
    /**
     * Get ValidationDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ValidationDetails[]|null
     */
    public function getValidationDetails()
    {
        return isset($this->ValidationDetails) ? $this->ValidationDetails : null;
    }
    /**
     * Set ValidationDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ValidationDetails[] $validationDetails
     * @return \ArrayType\ArrayOfValidationDetails
     */
    public function setValidationDetails(array $validationDetails = array())
    {
        foreach ($validationDetails as $arrayOfValidationDetailsValidationDetailsItem) {
            // validation for constraint: itemType
            if (!$arrayOfValidationDetailsValidationDetailsItem instanceof \StructType\ValidationDetails) {
                throw new \InvalidArgumentException(sprintf('The ValidationDetails property can only contain items of \StructType\ValidationDetails, "%s" given', is_object($arrayOfValidationDetailsValidationDetailsItem) ? get_class($arrayOfValidationDetailsValidationDetailsItem) : gettype($arrayOfValidationDetailsValidationDetailsItem)), __LINE__);
            }
        }
        if (is_null($validationDetails) || (is_array($validationDetails) && empty($validationDetails))) {
            unset($this->ValidationDetails);
        } else {
            $this->ValidationDetails = $validationDetails;
        }
        return $this;
    }
    /**
     * Add item to ValidationDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\ValidationDetails $item
     * @return \ArrayType\ArrayOfValidationDetails
     */
    public function addToValidationDetails(\StructType\ValidationDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ValidationDetails) {
            throw new \InvalidArgumentException(sprintf('The ValidationDetails property can only contain items of \StructType\ValidationDetails, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ValidationDetails[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ValidationDetails|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ValidationDetails|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ValidationDetails|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ValidationDetails|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ValidationDetails|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ValidationDetails
     */
    public function getAttributeName()
    {
        return 'ValidationDetails';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfValidationDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
