<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetQuoteTBAResult StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetQuoteTBAResult
 * @subpackage Structs
 */
class GetQuoteTBAResult extends AbstractStructBase
{
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The Fee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Fee;
    /**
     * The FromAccountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromAccountNumber;
    /**
     * The FxAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FxAmount;
    /**
     * The FxCurrencyID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FxCurrencyID;
    /**
     * The PaymentMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethod;
    /**
     * The Quote
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Quote
     */
    public $Quote;
    /**
     * The Rate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Rate;
    /**
     * The SettlementAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $SettlementAmount;
    /**
     * The SettlementCurrencyID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SettlementCurrencyID;
    /**
     * The ToAccountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToAccountNumber;
    /**
     * The TotalSettlementAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalSettlementAmount;
    /**
     * Constructor method for GetQuoteTBAResult
     * @uses GetQuoteTBAResult::setErrorCode()
     * @uses GetQuoteTBAResult::setErrorMessage()
     * @uses GetQuoteTBAResult::setFee()
     * @uses GetQuoteTBAResult::setFromAccountNumber()
     * @uses GetQuoteTBAResult::setFxAmount()
     * @uses GetQuoteTBAResult::setFxCurrencyID()
     * @uses GetQuoteTBAResult::setPaymentMethod()
     * @uses GetQuoteTBAResult::setQuote()
     * @uses GetQuoteTBAResult::setRate()
     * @uses GetQuoteTBAResult::setSettlementAmount()
     * @uses GetQuoteTBAResult::setSettlementCurrencyID()
     * @uses GetQuoteTBAResult::setToAccountNumber()
     * @uses GetQuoteTBAResult::setTotalSettlementAmount()
     * @param int $errorCode
     * @param string $errorMessage
     * @param float $fee
     * @param string $fromAccountNumber
     * @param float $fxAmount
     * @param string $fxCurrencyID
     * @param string $paymentMethod
     * @param \StructType\Quote $quote
     * @param float $rate
     * @param float $settlementAmount
     * @param string $settlementCurrencyID
     * @param string $toAccountNumber
     * @param float $totalSettlementAmount
     */
    public function __construct($errorCode = null, $errorMessage = null, $fee = null, $fromAccountNumber = null, $fxAmount = null, $fxCurrencyID = null, $paymentMethod = null, \StructType\Quote $quote = null, $rate = null, $settlementAmount = null, $settlementCurrencyID = null, $toAccountNumber = null, $totalSettlementAmount = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setFee($fee)
            ->setFromAccountNumber($fromAccountNumber)
            ->setFxAmount($fxAmount)
            ->setFxCurrencyID($fxCurrencyID)
            ->setPaymentMethod($paymentMethod)
            ->setQuote($quote)
            ->setRate($rate)
            ->setSettlementAmount($settlementAmount)
            ->setSettlementCurrencyID($settlementCurrencyID)
            ->setToAccountNumber($toAccountNumber)
            ->setTotalSettlementAmount($totalSettlementAmount);
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\GetQuoteTBAResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !is_numeric($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\GetQuoteTBAResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get Fee value
     * @return float|null
     */
    public function getFee()
    {
        return $this->Fee;
    }
    /**
     * Set Fee value
     * @param float $fee
     * @return \StructType\GetQuoteTBAResult
     */
    public function setFee($fee = null)
    {
        $this->Fee = $fee;
        return $this;
    }
    /**
     * Get FromAccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromAccountNumber()
    {
        return isset($this->FromAccountNumber) ? $this->FromAccountNumber : null;
    }
    /**
     * Set FromAccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromAccountNumber
     * @return \StructType\GetQuoteTBAResult
     */
    public function setFromAccountNumber($fromAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($fromAccountNumber) && !is_string($fromAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromAccountNumber)), __LINE__);
        }
        if (is_null($fromAccountNumber) || (is_array($fromAccountNumber) && empty($fromAccountNumber))) {
            unset($this->FromAccountNumber);
        } else {
            $this->FromAccountNumber = $fromAccountNumber;
        }
        return $this;
    }
    /**
     * Get FxAmount value
     * @return float|null
     */
    public function getFxAmount()
    {
        return $this->FxAmount;
    }
    /**
     * Set FxAmount value
     * @param float $fxAmount
     * @return \StructType\GetQuoteTBAResult
     */
    public function setFxAmount($fxAmount = null)
    {
        $this->FxAmount = $fxAmount;
        return $this;
    }
    /**
     * Get FxCurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFxCurrencyID()
    {
        return isset($this->FxCurrencyID) ? $this->FxCurrencyID : null;
    }
    /**
     * Set FxCurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fxCurrencyID
     * @return \StructType\GetQuoteTBAResult
     */
    public function setFxCurrencyID($fxCurrencyID = null)
    {
        // validation for constraint: string
        if (!is_null($fxCurrencyID) && !is_string($fxCurrencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fxCurrencyID)), __LINE__);
        }
        if (is_null($fxCurrencyID) || (is_array($fxCurrencyID) && empty($fxCurrencyID))) {
            unset($this->FxCurrencyID);
        } else {
            $this->FxCurrencyID = $fxCurrencyID;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethod
     * @return \StructType\GetQuoteTBAResult
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentMethod)), __LINE__);
        }
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get Quote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Quote|null
     */
    public function getQuote()
    {
        return isset($this->Quote) ? $this->Quote : null;
    }
    /**
     * Set Quote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Quote $quote
     * @return \StructType\GetQuoteTBAResult
     */
    public function setQuote(\StructType\Quote $quote = null)
    {
        if (is_null($quote) || (is_array($quote) && empty($quote))) {
            unset($this->Quote);
        } else {
            $this->Quote = $quote;
        }
        return $this;
    }
    /**
     * Get Rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param float $rate
     * @return \StructType\GetQuoteTBAResult
     */
    public function setRate($rate = null)
    {
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get SettlementAmount value
     * @return float|null
     */
    public function getSettlementAmount()
    {
        return $this->SettlementAmount;
    }
    /**
     * Set SettlementAmount value
     * @param float $settlementAmount
     * @return \StructType\GetQuoteTBAResult
     */
    public function setSettlementAmount($settlementAmount = null)
    {
        $this->SettlementAmount = $settlementAmount;
        return $this;
    }
    /**
     * Get SettlementCurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSettlementCurrencyID()
    {
        return isset($this->SettlementCurrencyID) ? $this->SettlementCurrencyID : null;
    }
    /**
     * Set SettlementCurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $settlementCurrencyID
     * @return \StructType\GetQuoteTBAResult
     */
    public function setSettlementCurrencyID($settlementCurrencyID = null)
    {
        // validation for constraint: string
        if (!is_null($settlementCurrencyID) && !is_string($settlementCurrencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($settlementCurrencyID)), __LINE__);
        }
        if (is_null($settlementCurrencyID) || (is_array($settlementCurrencyID) && empty($settlementCurrencyID))) {
            unset($this->SettlementCurrencyID);
        } else {
            $this->SettlementCurrencyID = $settlementCurrencyID;
        }
        return $this;
    }
    /**
     * Get ToAccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToAccountNumber()
    {
        return isset($this->ToAccountNumber) ? $this->ToAccountNumber : null;
    }
    /**
     * Set ToAccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toAccountNumber
     * @return \StructType\GetQuoteTBAResult
     */
    public function setToAccountNumber($toAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($toAccountNumber) && !is_string($toAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toAccountNumber)), __LINE__);
        }
        if (is_null($toAccountNumber) || (is_array($toAccountNumber) && empty($toAccountNumber))) {
            unset($this->ToAccountNumber);
        } else {
            $this->ToAccountNumber = $toAccountNumber;
        }
        return $this;
    }
    /**
     * Get TotalSettlementAmount value
     * @return float|null
     */
    public function getTotalSettlementAmount()
    {
        return $this->TotalSettlementAmount;
    }
    /**
     * Set TotalSettlementAmount value
     * @param float $totalSettlementAmount
     * @return \StructType\GetQuoteTBAResult
     */
    public function setTotalSettlementAmount($totalSettlementAmount = null)
    {
        $this->TotalSettlementAmount = $totalSettlementAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetQuoteTBAResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
