<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Payee ServiceType
 * @subpackage Services
 */
class Payee extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PayeeInfoValidation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PayeeInfoValidation $parameters
     * @return \StructType\PayeeInfoValidationResponse|bool
     */
    public function PayeeInfoValidation(\StructType\PayeeInfoValidation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PayeeInfoValidation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PayeeInfoValidationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
