<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 * @Author iBen
 */
class Ups_shipUnitType extends AbstractStructBase
{
    /**
     * The Number
     * @var string
     */
    public $Number;
    /**
     * The UnitOfMeasurement
     * @var \Ups_ship\UPSshipStruct\Ups_shipUnitOfMeasurementType
     */
    public $UnitOfMeasurement;
    /**
     * The Value
     * @var string
     */
    public $Value;
    /**
     * Constructor method for UnitType
     * @uses Ups_shipUnitType::setNumber()
     * @uses Ups_shipUnitType::setUnitOfMeasurement()
     * @uses Ups_shipUnitType::setValue()
     * @param string $number
     * @param \Ups_ship\UPSshipStruct\Ups_shipUnitOfMeasurementType $unitOfMeasurement
     * @param string $value
     */
    public function __construct($number = null, \Ups_ship\UPSshipStruct\Ups_shipUnitOfMeasurementType $unitOfMeasurement = null, $value = null)
    {
        $this
            ->setNumber($number)
            ->setUnitOfMeasurement($unitOfMeasurement)
            ->setValue($value);
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Ups_ship\UPSshipStruct\Ups_shipUnitType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get UnitOfMeasurement value
     * @return \Ups_ship\UPSshipStruct\Ups_shipUnitOfMeasurementType|null
     */
    public function getUnitOfMeasurement()
    {
        return $this->UnitOfMeasurement;
    }
    /**
     * Set UnitOfMeasurement value
     * @param \Ups_ship\UPSshipStruct\Ups_shipUnitOfMeasurementType $unitOfMeasurement
     * @return \Ups_ship\UPSshipStruct\Ups_shipUnitType
     */
    public function setUnitOfMeasurement(\Ups_ship\UPSshipStruct\Ups_shipUnitOfMeasurementType $unitOfMeasurement = null)
    {
        $this->UnitOfMeasurement = $unitOfMeasurement;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \Ups_ship\UPSshipStruct\Ups_shipUnitType
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
