<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipperType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 * @Author iBen
 */
class Ups_shipShipperType extends Ups_shipCompanyInfoType
{
    /**
     * The ShipperNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShipperNumber;
    /**
     * The FaxNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FaxNumber;
    /**
     * The EMailAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EMailAddress;
    /**
     * The Address
     * @var \Ups_ship\UPSshipStruct\Ups_shipShipAddressType
     */
    public $Address;
    /**
     * Constructor method for ShipperType
     * @uses Ups_shipShipperType::setShipperNumber()
     * @uses Ups_shipShipperType::setFaxNumber()
     * @uses Ups_shipShipperType::setEMailAddress()
     * @uses Ups_shipShipperType::setAddress()
     * @param string $shipperNumber
     * @param string $faxNumber
     * @param string $eMailAddress
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipAddressType $address
     */
    public function __construct($shipperNumber = null, $faxNumber = null, $eMailAddress = null, \Ups_ship\UPSshipStruct\Ups_shipShipAddressType $address = null)
    {
        $this
            ->setShipperNumber($shipperNumber)
            ->setFaxNumber($faxNumber)
            ->setEMailAddress($eMailAddress)
            ->setAddress($address);
    }
    /**
     * Get ShipperNumber value
     * @return string|null
     */
    public function getShipperNumber()
    {
        return $this->ShipperNumber;
    }
    /**
     * Set ShipperNumber value
     * @param string $shipperNumber
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipperType
     */
    public function setShipperNumber($shipperNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipperNumber) && !is_string($shipperNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperNumber, true), gettype($shipperNumber)), __LINE__);
        }
        $this->ShipperNumber = $shipperNumber;
        return $this;
    }
    /**
     * Get FaxNumber value
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->FaxNumber;
    }
    /**
     * Set FaxNumber value
     * @param string $faxNumber
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipperType
     */
    public function setFaxNumber($faxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($faxNumber) && !is_string($faxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faxNumber, true), gettype($faxNumber)), __LINE__);
        }
        $this->FaxNumber = $faxNumber;
        return $this;
    }
    /**
     * Get EMailAddress value
     * @return string|null
     */
    public function getEMailAddress()
    {
        return $this->EMailAddress;
    }
    /**
     * Set EMailAddress value
     * @param string $eMailAddress
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipperType
     */
    public function setEMailAddress($eMailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($eMailAddress) && !is_string($eMailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMailAddress, true), gettype($eMailAddress)), __LINE__);
        }
        $this->EMailAddress = $eMailAddress;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipAddressType $address
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipperType
     */
    public function setAddress(\Ups_ship\UPSshipStruct\Ups_shipShipAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
