<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipToType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 * @Author iBen
 */
class Ups_shipShipToType extends Ups_shipCompanyInfoType
{
    /**
     * The FaxNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FaxNumber;
    /**
     * The EMailAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EMailAddress;
    /**
     * The Address
     * @var \Ups_ship\UPSshipStruct\Ups_shipShipToAddressType
     */
    public $Address;
    /**
     * The LocationID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LocationID;
    /**
     * Constructor method for ShipToType
     * @uses Ups_shipShipToType::setFaxNumber()
     * @uses Ups_shipShipToType::setEMailAddress()
     * @uses Ups_shipShipToType::setAddress()
     * @uses Ups_shipShipToType::setLocationID()
     * @param string $faxNumber
     * @param string $eMailAddress
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipToAddressType $address
     * @param string $locationID
     */
    public function __construct($faxNumber = null, $eMailAddress = null, \Ups_ship\UPSshipStruct\Ups_shipShipToAddressType $address = null, $locationID = null)
    {
        $this
            ->setFaxNumber($faxNumber)
            ->setEMailAddress($eMailAddress)
            ->setAddress($address)
            ->setLocationID($locationID);
    }
    /**
     * Get FaxNumber value
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->FaxNumber;
    }
    /**
     * Set FaxNumber value
     * @param string $faxNumber
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipToType
     */
    public function setFaxNumber($faxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($faxNumber) && !is_string($faxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faxNumber, true), gettype($faxNumber)), __LINE__);
        }
        $this->FaxNumber = $faxNumber;
        return $this;
    }
    /**
     * Get EMailAddress value
     * @return string|null
     */
    public function getEMailAddress()
    {
        return $this->EMailAddress;
    }
    /**
     * Set EMailAddress value
     * @param string $eMailAddress
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipToType
     */
    public function setEMailAddress($eMailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($eMailAddress) && !is_string($eMailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMailAddress, true), gettype($eMailAddress)), __LINE__);
        }
        $this->EMailAddress = $eMailAddress;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipToAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipToAddressType $address
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipToType
     */
    public function setAddress(\Ups_ship\UPSshipStruct\Ups_shipShipToAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get LocationID value
     * @return string|null
     */
    public function getLocationID()
    {
        return $this->LocationID;
    }
    /**
     * Set LocationID value
     * @param string $locationID
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipToType
     */
    public function setLocationID($locationID = null)
    {
        // validation for constraint: string
        if (!is_null($locationID) && !is_string($locationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationID, true), gettype($locationID)), __LINE__);
        }
        $this->LocationID = $locationID;
        return $this;
    }
}
