<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageWeightType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 * @Author iBen
 */
class Ups_shipPackageWeightType extends AbstractStructBase
{
    /**
     * The UnitOfMeasurement
     * @var \Ups_ship\UPSshipStruct\Ups_shipShipUnitOfMeasurementType
     */
    public $UnitOfMeasurement;
    /**
     * The Weight
     * @var string
     */
    public $Weight;
    /**
     * Constructor method for PackageWeightType
     * @uses Ups_shipPackageWeightType::setUnitOfMeasurement()
     * @uses Ups_shipPackageWeightType::setWeight()
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipUnitOfMeasurementType $unitOfMeasurement
     * @param string $weight
     */
    public function __construct(\Ups_ship\UPSshipStruct\Ups_shipShipUnitOfMeasurementType $unitOfMeasurement = null, $weight = null)
    {
        $this
            ->setUnitOfMeasurement($unitOfMeasurement)
            ->setWeight($weight);
    }
    /**
     * Get UnitOfMeasurement value
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipUnitOfMeasurementType|null
     */
    public function getUnitOfMeasurement()
    {
        return $this->UnitOfMeasurement;
    }
    /**
     * Set UnitOfMeasurement value
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipUnitOfMeasurementType $unitOfMeasurement
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageWeightType
     */
    public function setUnitOfMeasurement(\Ups_ship\UPSshipStruct\Ups_shipShipUnitOfMeasurementType $unitOfMeasurement = null)
    {
        $this->UnitOfMeasurement = $unitOfMeasurement;
        return $this;
    }
    /**
     * Get Weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param string $weight
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageWeightType
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
}
