<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageDeclaredValueType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 * @Author iBen
 */
class Ups_shipPackageDeclaredValueType extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipDeclaredValueType
     */
    public $Type;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The MonetaryValue
     * @var string
     */
    public $MonetaryValue;
    /**
     * Constructor method for PackageDeclaredValueType
     * @uses Ups_shipPackageDeclaredValueType::setType()
     * @uses Ups_shipPackageDeclaredValueType::setCurrencyCode()
     * @uses Ups_shipPackageDeclaredValueType::setMonetaryValue()
     * @param \Ups_ship\UPSshipStruct\Ups_shipDeclaredValueType $type
     * @param string $currencyCode
     * @param string $monetaryValue
     */
    public function __construct(\Ups_ship\UPSshipStruct\Ups_shipDeclaredValueType $type = null, $currencyCode = null, $monetaryValue = null)
    {
        $this
            ->setType($type)
            ->setCurrencyCode($currencyCode)
            ->setMonetaryValue($monetaryValue);
    }
    /**
     * Get Type value
     * @return \Ups_ship\UPSshipStruct\Ups_shipDeclaredValueType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \Ups_ship\UPSshipStruct\Ups_shipDeclaredValueType $type
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageDeclaredValueType
     */
    public function setType(\Ups_ship\UPSshipStruct\Ups_shipDeclaredValueType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageDeclaredValueType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get MonetaryValue value
     * @return string|null
     */
    public function getMonetaryValue()
    {
        return $this->MonetaryValue;
    }
    /**
     * Set MonetaryValue value
     * @param string $monetaryValue
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageDeclaredValueType
     */
    public function setMonetaryValue($monetaryValue = null)
    {
        // validation for constraint: string
        if (!is_null($monetaryValue) && !is_string($monetaryValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monetaryValue, true), gettype($monetaryValue)), __LINE__);
        }
        $this->MonetaryValue = $monetaryValue;
        return $this;
    }
}
