<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstimatedDutiesAndTaxesType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 * @Author iBen
 */
class Ups_shipEstimatedDutiesAndTaxesType extends AbstractStructBase
{
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The MonetaryValue
     * @var string
     */
    public $MonetaryValue;
    /**
     * The BrokerageFees
     * @var \Ups_ship\UPSshipStruct\Ups_shipBrokerageFeesType
     */
    public $BrokerageFees;
    /**
     * Constructor method for EstimatedDutiesAndTaxesType
     * @uses Ups_shipEstimatedDutiesAndTaxesType::setCurrencyCode()
     * @uses Ups_shipEstimatedDutiesAndTaxesType::setMonetaryValue()
     * @uses Ups_shipEstimatedDutiesAndTaxesType::setBrokerageFees()
     * @param string $currencyCode
     * @param string $monetaryValue
     * @param \Ups_ship\UPSshipStruct\Ups_shipBrokerageFeesType $brokerageFees
     */
    public function __construct($currencyCode = null, $monetaryValue = null, \Ups_ship\UPSshipStruct\Ups_shipBrokerageFeesType $brokerageFees = null)
    {
        $this
            ->setCurrencyCode($currencyCode)
            ->setMonetaryValue($monetaryValue)
            ->setBrokerageFees($brokerageFees);
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Ups_ship\UPSshipStruct\Ups_shipEstimatedDutiesAndTaxesType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get MonetaryValue value
     * @return string|null
     */
    public function getMonetaryValue()
    {
        return $this->MonetaryValue;
    }
    /**
     * Set MonetaryValue value
     * @param string $monetaryValue
     * @return \Ups_ship\UPSshipStruct\Ups_shipEstimatedDutiesAndTaxesType
     */
    public function setMonetaryValue($monetaryValue = null)
    {
        // validation for constraint: string
        if (!is_null($monetaryValue) && !is_string($monetaryValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monetaryValue, true), gettype($monetaryValue)), __LINE__);
        }
        $this->MonetaryValue = $monetaryValue;
        return $this;
    }
    /**
     * Get BrokerageFees value
     * @return \Ups_ship\UPSshipStruct\Ups_shipBrokerageFeesType|null
     */
    public function getBrokerageFees()
    {
        return $this->BrokerageFees;
    }
    /**
     * Set BrokerageFees value
     * @param \Ups_ship\UPSshipStruct\Ups_shipBrokerageFeesType $brokerageFees
     * @return \Ups_ship\UPSshipStruct\Ups_shipEstimatedDutiesAndTaxesType
     */
    public function setBrokerageFees(\Ups_ship\UPSshipStruct\Ups_shipBrokerageFeesType $brokerageFees = null)
    {
        $this->BrokerageFees = $brokerageFees;
        return $this;
    }
}
