<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentResultsType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 * @Author iBen
 */
class Ups_shipShipmentResultsType extends AbstractStructBase
{
    /**
     * The Disclaimer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipDisclaimerType[]
     */
    public $Disclaimer;
    /**
     * The ShipmentCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipShipmentChargesType
     */
    public $ShipmentCharges;
    /**
     * The NegotiatedRateCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipNegotiatedRateChargesType
     */
    public $NegotiatedRateCharges;
    /**
     * The FRSShipmentData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipFRSShipmentDataType
     */
    public $FRSShipmentData;
    /**
     * The RatingMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RatingMethod;
    /**
     * The BillableWeightCalculationMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BillableWeightCalculationMethod;
    /**
     * The BillingWeight
     * @var \Ups_ship\UPSshipStruct\Ups_shipBillingWeightType
     */
    public $BillingWeight;
    /**
     * The ShipmentIdentificationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentIdentificationNumber;
    /**
     * The MIDualReturnShipmentKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MIDualReturnShipmentKey;
    /**
     * The ShipmentDigest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentDigest;
    /**
     * The PackageResults
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType[]
     */
    public $PackageResults;
    /**
     * The ControlLogReceipt
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipImageType[]
     */
    public $ControlLogReceipt;
    /**
     * The Form
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipFormType
     */
    public $Form;
    /**
     * The CODTurnInPage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipSCReportType
     */
    public $CODTurnInPage;
    /**
     * The HighValueReport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipHighValueReportType
     */
    public $HighValueReport;
    /**
     * The LabelURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LabelURL;
    /**
     * The LocalLanguageLabelURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LocalLanguageLabelURL;
    /**
     * The ReceiptURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReceiptURL;
    /**
     * The LocalLanguageReceiptURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LocalLanguageReceiptURL;
    /**
     * The DGPaperImage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DGPaperImage;
    /**
     * The MasterCartonID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MasterCartonID;
    /**
     * Constructor method for ShipmentResultsType
     * @uses Ups_shipShipmentResultsType::setDisclaimer()
     * @uses Ups_shipShipmentResultsType::setShipmentCharges()
     * @uses Ups_shipShipmentResultsType::setNegotiatedRateCharges()
     * @uses Ups_shipShipmentResultsType::setFRSShipmentData()
     * @uses Ups_shipShipmentResultsType::setRatingMethod()
     * @uses Ups_shipShipmentResultsType::setBillableWeightCalculationMethod()
     * @uses Ups_shipShipmentResultsType::setBillingWeight()
     * @uses Ups_shipShipmentResultsType::setShipmentIdentificationNumber()
     * @uses Ups_shipShipmentResultsType::setMIDualReturnShipmentKey()
     * @uses Ups_shipShipmentResultsType::setShipmentDigest()
     * @uses Ups_shipShipmentResultsType::setPackageResults()
     * @uses Ups_shipShipmentResultsType::setControlLogReceipt()
     * @uses Ups_shipShipmentResultsType::setForm()
     * @uses Ups_shipShipmentResultsType::setCODTurnInPage()
     * @uses Ups_shipShipmentResultsType::setHighValueReport()
     * @uses Ups_shipShipmentResultsType::setLabelURL()
     * @uses Ups_shipShipmentResultsType::setLocalLanguageLabelURL()
     * @uses Ups_shipShipmentResultsType::setReceiptURL()
     * @uses Ups_shipShipmentResultsType::setLocalLanguageReceiptURL()
     * @uses Ups_shipShipmentResultsType::setDGPaperImage()
     * @uses Ups_shipShipmentResultsType::setMasterCartonID()
     * @param \Ups_ship\UPSshipStruct\Ups_shipDisclaimerType[] $disclaimer
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipmentChargesType $shipmentCharges
     * @param \Ups_ship\UPSshipStruct\Ups_shipNegotiatedRateChargesType $negotiatedRateCharges
     * @param \Ups_ship\UPSshipStruct\Ups_shipFRSShipmentDataType $fRSShipmentData
     * @param string $ratingMethod
     * @param string $billableWeightCalculationMethod
     * @param \Ups_ship\UPSshipStruct\Ups_shipBillingWeightType $billingWeight
     * @param string $shipmentIdentificationNumber
     * @param string $mIDualReturnShipmentKey
     * @param string $shipmentDigest
     * @param \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType[] $packageResults
     * @param \Ups_ship\UPSshipStruct\Ups_shipImageType[] $controlLogReceipt
     * @param \Ups_ship\UPSshipStruct\Ups_shipFormType $form
     * @param \Ups_ship\UPSshipStruct\Ups_shipSCReportType $cODTurnInPage
     * @param \Ups_ship\UPSshipStruct\Ups_shipHighValueReportType $highValueReport
     * @param string $labelURL
     * @param string $localLanguageLabelURL
     * @param string $receiptURL
     * @param string $localLanguageReceiptURL
     * @param string[] $dGPaperImage
     * @param string $masterCartonID
     */
    public function __construct(array $disclaimer = array(), \Ups_ship\UPSshipStruct\Ups_shipShipmentChargesType $shipmentCharges = null, \Ups_ship\UPSshipStruct\Ups_shipNegotiatedRateChargesType $negotiatedRateCharges = null, \Ups_ship\UPSshipStruct\Ups_shipFRSShipmentDataType $fRSShipmentData = null, $ratingMethod = null, $billableWeightCalculationMethod = null, \Ups_ship\UPSshipStruct\Ups_shipBillingWeightType $billingWeight = null, $shipmentIdentificationNumber = null, $mIDualReturnShipmentKey = null, $shipmentDigest = null, array $packageResults = array(), array $controlLogReceipt = array(), \Ups_ship\UPSshipStruct\Ups_shipFormType $form = null, \Ups_ship\UPSshipStruct\Ups_shipSCReportType $cODTurnInPage = null, \Ups_ship\UPSshipStruct\Ups_shipHighValueReportType $highValueReport = null, $labelURL = null, $localLanguageLabelURL = null, $receiptURL = null, $localLanguageReceiptURL = null, array $dGPaperImage = array(), $masterCartonID = null)
    {
        $this
            ->setDisclaimer($disclaimer)
            ->setShipmentCharges($shipmentCharges)
            ->setNegotiatedRateCharges($negotiatedRateCharges)
            ->setFRSShipmentData($fRSShipmentData)
            ->setRatingMethod($ratingMethod)
            ->setBillableWeightCalculationMethod($billableWeightCalculationMethod)
            ->setBillingWeight($billingWeight)
            ->setShipmentIdentificationNumber($shipmentIdentificationNumber)
            ->setMIDualReturnShipmentKey($mIDualReturnShipmentKey)
            ->setShipmentDigest($shipmentDigest)
            ->setPackageResults($packageResults)
            ->setControlLogReceipt($controlLogReceipt)
            ->setForm($form)
            ->setCODTurnInPage($cODTurnInPage)
            ->setHighValueReport($highValueReport)
            ->setLabelURL($labelURL)
            ->setLocalLanguageLabelURL($localLanguageLabelURL)
            ->setReceiptURL($receiptURL)
            ->setLocalLanguageReceiptURL($localLanguageReceiptURL)
            ->setDGPaperImage($dGPaperImage)
            ->setMasterCartonID($masterCartonID);
    }
    /**
     * Get Disclaimer value
     * @return \Ups_ship\UPSshipStruct\Ups_shipDisclaimerType[]|null
     */
    public function getDisclaimer()
    {
        return $this->Disclaimer;
    }
    /**
     * This method is responsible for validating the values passed to the setDisclaimer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDisclaimer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDisclaimerForArrayConstraintsFromSetDisclaimer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentResultsTypeDisclaimerItem) {
            // validation for constraint: itemType
            if (!$shipmentResultsTypeDisclaimerItem instanceof \Ups_ship\UPSshipStruct\Ups_shipDisclaimerType) {
                $invalidValues[] = is_object($shipmentResultsTypeDisclaimerItem) ? get_class($shipmentResultsTypeDisclaimerItem) : sprintf('%s(%s)', gettype($shipmentResultsTypeDisclaimerItem), var_export($shipmentResultsTypeDisclaimerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Disclaimer property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipDisclaimerType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Disclaimer value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipDisclaimerType[] $disclaimer
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function setDisclaimer(array $disclaimer = array())
    {
        // validation for constraint: array
        if ('' !== ($disclaimerArrayErrorMessage = self::validateDisclaimerForArrayConstraintsFromSetDisclaimer($disclaimer))) {
            throw new \InvalidArgumentException($disclaimerArrayErrorMessage, __LINE__);
        }
        $this->Disclaimer = $disclaimer;
        return $this;
    }
    /**
     * Add item to Disclaimer value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipDisclaimerType $item
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function addToDisclaimer(\Ups_ship\UPSshipStruct\Ups_shipDisclaimerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_ship\UPSshipStruct\Ups_shipDisclaimerType) {
            throw new \InvalidArgumentException(sprintf('The Disclaimer property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipDisclaimerType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Disclaimer[] = $item;
        return $this;
    }
    /**
     * Get ShipmentCharges value
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentChargesType|null
     */
    public function getShipmentCharges()
    {
        return $this->ShipmentCharges;
    }
    /**
     * Set ShipmentCharges value
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipmentChargesType $shipmentCharges
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function setShipmentCharges(\Ups_ship\UPSshipStruct\Ups_shipShipmentChargesType $shipmentCharges = null)
    {
        $this->ShipmentCharges = $shipmentCharges;
        return $this;
    }
    /**
     * Get NegotiatedRateCharges value
     * @return \Ups_ship\UPSshipStruct\Ups_shipNegotiatedRateChargesType|null
     */
    public function getNegotiatedRateCharges()
    {
        return $this->NegotiatedRateCharges;
    }
    /**
     * Set NegotiatedRateCharges value
     * @param \Ups_ship\UPSshipStruct\Ups_shipNegotiatedRateChargesType $negotiatedRateCharges
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function setNegotiatedRateCharges(\Ups_ship\UPSshipStruct\Ups_shipNegotiatedRateChargesType $negotiatedRateCharges = null)
    {
        $this->NegotiatedRateCharges = $negotiatedRateCharges;
        return $this;
    }
    /**
     * Get FRSShipmentData value
     * @return \Ups_ship\UPSshipStruct\Ups_shipFRSShipmentDataType|null
     */
    public function getFRSShipmentData()
    {
        return $this->FRSShipmentData;
    }
    /**
     * Set FRSShipmentData value
     * @param \Ups_ship\UPSshipStruct\Ups_shipFRSShipmentDataType $fRSShipmentData
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function setFRSShipmentData(\Ups_ship\UPSshipStruct\Ups_shipFRSShipmentDataType $fRSShipmentData = null)
    {
        $this->FRSShipmentData = $fRSShipmentData;
        return $this;
    }
    /**
     * Get RatingMethod value
     * @return string|null
     */
    public function getRatingMethod()
    {
        return $this->RatingMethod;
    }
    /**
     * Set RatingMethod value
     * @param string $ratingMethod
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function setRatingMethod($ratingMethod = null)
    {
        // validation for constraint: string
        if (!is_null($ratingMethod) && !is_string($ratingMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratingMethod, true), gettype($ratingMethod)), __LINE__);
        }
        $this->RatingMethod = $ratingMethod;
        return $this;
    }
    /**
     * Get BillableWeightCalculationMethod value
     * @return string|null
     */
    public function getBillableWeightCalculationMethod()
    {
        return $this->BillableWeightCalculationMethod;
    }
    /**
     * Set BillableWeightCalculationMethod value
     * @param string $billableWeightCalculationMethod
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function setBillableWeightCalculationMethod($billableWeightCalculationMethod = null)
    {
        // validation for constraint: string
        if (!is_null($billableWeightCalculationMethod) && !is_string($billableWeightCalculationMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billableWeightCalculationMethod, true), gettype($billableWeightCalculationMethod)), __LINE__);
        }
        $this->BillableWeightCalculationMethod = $billableWeightCalculationMethod;
        return $this;
    }
    /**
     * Get BillingWeight value
     * @return \Ups_ship\UPSshipStruct\Ups_shipBillingWeightType|null
     */
    public function getBillingWeight()
    {
        return $this->BillingWeight;
    }
    /**
     * Set BillingWeight value
     * @param \Ups_ship\UPSshipStruct\Ups_shipBillingWeightType $billingWeight
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function setBillingWeight(\Ups_ship\UPSshipStruct\Ups_shipBillingWeightType $billingWeight = null)
    {
        $this->BillingWeight = $billingWeight;
        return $this;
    }
    /**
     * Get ShipmentIdentificationNumber value
     * @return string|null
     */
    public function getShipmentIdentificationNumber()
    {
        return $this->ShipmentIdentificationNumber;
    }
    /**
     * Set ShipmentIdentificationNumber value
     * @param string $shipmentIdentificationNumber
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function setShipmentIdentificationNumber($shipmentIdentificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentIdentificationNumber) && !is_string($shipmentIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentIdentificationNumber, true), gettype($shipmentIdentificationNumber)), __LINE__);
        }
        $this->ShipmentIdentificationNumber = $shipmentIdentificationNumber;
        return $this;
    }
    /**
     * Get MIDualReturnShipmentKey value
     * @return string|null
     */
    public function getMIDualReturnShipmentKey()
    {
        return $this->MIDualReturnShipmentKey;
    }
    /**
     * Set MIDualReturnShipmentKey value
     * @param string $mIDualReturnShipmentKey
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function setMIDualReturnShipmentKey($mIDualReturnShipmentKey = null)
    {
        // validation for constraint: string
        if (!is_null($mIDualReturnShipmentKey) && !is_string($mIDualReturnShipmentKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mIDualReturnShipmentKey, true), gettype($mIDualReturnShipmentKey)), __LINE__);
        }
        $this->MIDualReturnShipmentKey = $mIDualReturnShipmentKey;
        return $this;
    }
    /**
     * Get ShipmentDigest value
     * @return string|null
     */
    public function getShipmentDigest()
    {
        return $this->ShipmentDigest;
    }
    /**
     * Set ShipmentDigest value
     * @param string $shipmentDigest
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function setShipmentDigest($shipmentDigest = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentDigest) && !is_string($shipmentDigest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentDigest, true), gettype($shipmentDigest)), __LINE__);
        }
        $this->ShipmentDigest = $shipmentDigest;
        return $this;
    }
    /**
     * Get PackageResults value
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType[]|null
     */
    public function getPackageResults()
    {
        return $this->PackageResults;
    }
    /**
     * This method is responsible for validating the values passed to the setPackageResults method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackageResults method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageResultsForArrayConstraintsFromSetPackageResults(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentResultsTypePackageResultsItem) {
            // validation for constraint: itemType
            if (!$shipmentResultsTypePackageResultsItem instanceof \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType) {
                $invalidValues[] = is_object($shipmentResultsTypePackageResultsItem) ? get_class($shipmentResultsTypePackageResultsItem) : sprintf('%s(%s)', gettype($shipmentResultsTypePackageResultsItem), var_export($shipmentResultsTypePackageResultsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PackageResults property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PackageResults value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType[] $packageResults
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function setPackageResults(array $packageResults = array())
    {
        // validation for constraint: array
        if ('' !== ($packageResultsArrayErrorMessage = self::validatePackageResultsForArrayConstraintsFromSetPackageResults($packageResults))) {
            throw new \InvalidArgumentException($packageResultsArrayErrorMessage, __LINE__);
        }
        $this->PackageResults = $packageResults;
        return $this;
    }
    /**
     * Add item to PackageResults value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType $item
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function addToPackageResults(\Ups_ship\UPSshipStruct\Ups_shipPackageResultsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType) {
            throw new \InvalidArgumentException(sprintf('The PackageResults property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipPackageResultsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PackageResults[] = $item;
        return $this;
    }
    /**
     * Get ControlLogReceipt value
     * @return \Ups_ship\UPSshipStruct\Ups_shipImageType[]|null
     */
    public function getControlLogReceipt()
    {
        return $this->ControlLogReceipt;
    }
    /**
     * This method is responsible for validating the values passed to the setControlLogReceipt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setControlLogReceipt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateControlLogReceiptForArrayConstraintsFromSetControlLogReceipt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentResultsTypeControlLogReceiptItem) {
            // validation for constraint: itemType
            if (!$shipmentResultsTypeControlLogReceiptItem instanceof \Ups_ship\UPSshipStruct\Ups_shipImageType) {
                $invalidValues[] = is_object($shipmentResultsTypeControlLogReceiptItem) ? get_class($shipmentResultsTypeControlLogReceiptItem) : sprintf('%s(%s)', gettype($shipmentResultsTypeControlLogReceiptItem), var_export($shipmentResultsTypeControlLogReceiptItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ControlLogReceipt property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipImageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ControlLogReceipt value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipImageType[] $controlLogReceipt
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function setControlLogReceipt(array $controlLogReceipt = array())
    {
        // validation for constraint: array
        if ('' !== ($controlLogReceiptArrayErrorMessage = self::validateControlLogReceiptForArrayConstraintsFromSetControlLogReceipt($controlLogReceipt))) {
            throw new \InvalidArgumentException($controlLogReceiptArrayErrorMessage, __LINE__);
        }
        $this->ControlLogReceipt = $controlLogReceipt;
        return $this;
    }
    /**
     * Add item to ControlLogReceipt value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipImageType $item
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function addToControlLogReceipt(\Ups_ship\UPSshipStruct\Ups_shipImageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_ship\UPSshipStruct\Ups_shipImageType) {
            throw new \InvalidArgumentException(sprintf('The ControlLogReceipt property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipImageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ControlLogReceipt[] = $item;
        return $this;
    }
    /**
     * Get Form value
     * @return \Ups_ship\UPSshipStruct\Ups_shipFormType|null
     */
    public function getForm()
    {
        return $this->Form;
    }
    /**
     * Set Form value
     * @param \Ups_ship\UPSshipStruct\Ups_shipFormType $form
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function setForm(\Ups_ship\UPSshipStruct\Ups_shipFormType $form = null)
    {
        $this->Form = $form;
        return $this;
    }
    /**
     * Get CODTurnInPage value
     * @return \Ups_ship\UPSshipStruct\Ups_shipSCReportType|null
     */
    public function getCODTurnInPage()
    {
        return $this->CODTurnInPage;
    }
    /**
     * Set CODTurnInPage value
     * @param \Ups_ship\UPSshipStruct\Ups_shipSCReportType $cODTurnInPage
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function setCODTurnInPage(\Ups_ship\UPSshipStruct\Ups_shipSCReportType $cODTurnInPage = null)
    {
        $this->CODTurnInPage = $cODTurnInPage;
        return $this;
    }
    /**
     * Get HighValueReport value
     * @return \Ups_ship\UPSshipStruct\Ups_shipHighValueReportType|null
     */
    public function getHighValueReport()
    {
        return $this->HighValueReport;
    }
    /**
     * Set HighValueReport value
     * @param \Ups_ship\UPSshipStruct\Ups_shipHighValueReportType $highValueReport
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function setHighValueReport(\Ups_ship\UPSshipStruct\Ups_shipHighValueReportType $highValueReport = null)
    {
        $this->HighValueReport = $highValueReport;
        return $this;
    }
    /**
     * Get LabelURL value
     * @return string|null
     */
    public function getLabelURL()
    {
        return $this->LabelURL;
    }
    /**
     * Set LabelURL value
     * @param string $labelURL
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function setLabelURL($labelURL = null)
    {
        // validation for constraint: string
        if (!is_null($labelURL) && !is_string($labelURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelURL, true), gettype($labelURL)), __LINE__);
        }
        $this->LabelURL = $labelURL;
        return $this;
    }
    /**
     * Get LocalLanguageLabelURL value
     * @return string|null
     */
    public function getLocalLanguageLabelURL()
    {
        return $this->LocalLanguageLabelURL;
    }
    /**
     * Set LocalLanguageLabelURL value
     * @param string $localLanguageLabelURL
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function setLocalLanguageLabelURL($localLanguageLabelURL = null)
    {
        // validation for constraint: string
        if (!is_null($localLanguageLabelURL) && !is_string($localLanguageLabelURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localLanguageLabelURL, true), gettype($localLanguageLabelURL)), __LINE__);
        }
        $this->LocalLanguageLabelURL = $localLanguageLabelURL;
        return $this;
    }
    /**
     * Get ReceiptURL value
     * @return string|null
     */
    public function getReceiptURL()
    {
        return $this->ReceiptURL;
    }
    /**
     * Set ReceiptURL value
     * @param string $receiptURL
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function setReceiptURL($receiptURL = null)
    {
        // validation for constraint: string
        if (!is_null($receiptURL) && !is_string($receiptURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptURL, true), gettype($receiptURL)), __LINE__);
        }
        $this->ReceiptURL = $receiptURL;
        return $this;
    }
    /**
     * Get LocalLanguageReceiptURL value
     * @return string|null
     */
    public function getLocalLanguageReceiptURL()
    {
        return $this->LocalLanguageReceiptURL;
    }
    /**
     * Set LocalLanguageReceiptURL value
     * @param string $localLanguageReceiptURL
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function setLocalLanguageReceiptURL($localLanguageReceiptURL = null)
    {
        // validation for constraint: string
        if (!is_null($localLanguageReceiptURL) && !is_string($localLanguageReceiptURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localLanguageReceiptURL, true), gettype($localLanguageReceiptURL)), __LINE__);
        }
        $this->LocalLanguageReceiptURL = $localLanguageReceiptURL;
        return $this;
    }
    /**
     * Get DGPaperImage value
     * @return string[]|null
     */
    public function getDGPaperImage()
    {
        return $this->DGPaperImage;
    }
    /**
     * This method is responsible for validating the values passed to the setDGPaperImage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDGPaperImage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDGPaperImageForArrayConstraintsFromSetDGPaperImage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentResultsTypeDGPaperImageItem) {
            // validation for constraint: itemType
            if (!is_string($shipmentResultsTypeDGPaperImageItem)) {
                $invalidValues[] = is_object($shipmentResultsTypeDGPaperImageItem) ? get_class($shipmentResultsTypeDGPaperImageItem) : sprintf('%s(%s)', gettype($shipmentResultsTypeDGPaperImageItem), var_export($shipmentResultsTypeDGPaperImageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DGPaperImage property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DGPaperImage value
     * @throws \InvalidArgumentException
     * @param string[] $dGPaperImage
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function setDGPaperImage(array $dGPaperImage = array())
    {
        // validation for constraint: array
        if ('' !== ($dGPaperImageArrayErrorMessage = self::validateDGPaperImageForArrayConstraintsFromSetDGPaperImage($dGPaperImage))) {
            throw new \InvalidArgumentException($dGPaperImageArrayErrorMessage, __LINE__);
        }
        $this->DGPaperImage = $dGPaperImage;
        return $this;
    }
    /**
     * Add item to DGPaperImage value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function addToDGPaperImage($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DGPaperImage property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DGPaperImage[] = $item;
        return $this;
    }
    /**
     * Get MasterCartonID value
     * @return string|null
     */
    public function getMasterCartonID()
    {
        return $this->MasterCartonID;
    }
    /**
     * Set MasterCartonID value
     * @param string $masterCartonID
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentResultsType
     */
    public function setMasterCartonID($masterCartonID = null)
    {
        // validation for constraint: string
        if (!is_null($masterCartonID) && !is_string($masterCartonID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterCartonID, true), gettype($masterCartonID)), __LINE__);
        }
        $this->MasterCartonID = $masterCartonID;
        return $this;
    }
}
