<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 * @Author iBen
 */
class Ups_shipPackageType extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The PalletDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PalletDescription;
    /**
     * The NumOfPieces
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NumOfPieces;
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UnitPrice;
    /**
     * The Packaging
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipPackagingType
     */
    public $Packaging;
    /**
     * The Dimensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipDimensionsType
     */
    public $Dimensions;
    /**
     * The DimWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipPackageWeightType
     */
    public $DimWeight;
    /**
     * The PackageWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipPackageWeightType
     */
    public $PackageWeight;
    /**
     * The LargePackageIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LargePackageIndicator;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipReferenceNumberType[]
     */
    public $ReferenceNumber;
    /**
     * The AdditionalHandlingIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AdditionalHandlingIndicator;
    /**
     * The PackageServiceOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsType
     */
    public $PackageServiceOptions;
    /**
     * The Commodity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipCommodityType
     */
    public $Commodity;
    /**
     * The HazMatPackageInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipHazMatPackageInformationType
     */
    public $HazMatPackageInformation;
    /**
     * The SimpleRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipCodeDescriptionType
     */
    public $SimpleRate;
    /**
     * The UPSPremier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipUPSPremierType
     */
    public $UPSPremier;
    /**
     * The OversizeIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OversizeIndicator;
    /**
     * The MinimumBillableWeightIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MinimumBillableWeightIndicator;
    /**
     * Constructor method for PackageType
     * @uses Ups_shipPackageType::setDescription()
     * @uses Ups_shipPackageType::setPalletDescription()
     * @uses Ups_shipPackageType::setNumOfPieces()
     * @uses Ups_shipPackageType::setUnitPrice()
     * @uses Ups_shipPackageType::setPackaging()
     * @uses Ups_shipPackageType::setDimensions()
     * @uses Ups_shipPackageType::setDimWeight()
     * @uses Ups_shipPackageType::setPackageWeight()
     * @uses Ups_shipPackageType::setLargePackageIndicator()
     * @uses Ups_shipPackageType::setReferenceNumber()
     * @uses Ups_shipPackageType::setAdditionalHandlingIndicator()
     * @uses Ups_shipPackageType::setPackageServiceOptions()
     * @uses Ups_shipPackageType::setCommodity()
     * @uses Ups_shipPackageType::setHazMatPackageInformation()
     * @uses Ups_shipPackageType::setSimpleRate()
     * @uses Ups_shipPackageType::setUPSPremier()
     * @uses Ups_shipPackageType::setOversizeIndicator()
     * @uses Ups_shipPackageType::setMinimumBillableWeightIndicator()
     * @param string $description
     * @param string $palletDescription
     * @param string $numOfPieces
     * @param string $unitPrice
     * @param \Ups_ship\UPSshipStruct\Ups_shipPackagingType $packaging
     * @param \Ups_ship\UPSshipStruct\Ups_shipDimensionsType $dimensions
     * @param \Ups_ship\UPSshipStruct\Ups_shipPackageWeightType $dimWeight
     * @param \Ups_ship\UPSshipStruct\Ups_shipPackageWeightType $packageWeight
     * @param string $largePackageIndicator
     * @param \Ups_ship\UPSshipStruct\Ups_shipReferenceNumberType[] $referenceNumber
     * @param string $additionalHandlingIndicator
     * @param \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsType $packageServiceOptions
     * @param \Ups_ship\UPSshipStruct\Ups_shipCommodityType $commodity
     * @param \Ups_ship\UPSshipStruct\Ups_shipHazMatPackageInformationType $hazMatPackageInformation
     * @param \Ups_ship\UPSshipStruct\Ups_shipCodeDescriptionType $simpleRate
     * @param \Ups_ship\UPSshipStruct\Ups_shipUPSPremierType $uPSPremier
     * @param string $oversizeIndicator
     * @param string $minimumBillableWeightIndicator
     */
    public function __construct($description = null, $palletDescription = null, $numOfPieces = null, $unitPrice = null, \Ups_ship\UPSshipStruct\Ups_shipPackagingType $packaging = null, \Ups_ship\UPSshipStruct\Ups_shipDimensionsType $dimensions = null, \Ups_ship\UPSshipStruct\Ups_shipPackageWeightType $dimWeight = null, \Ups_ship\UPSshipStruct\Ups_shipPackageWeightType $packageWeight = null, $largePackageIndicator = null, array $referenceNumber = array(), $additionalHandlingIndicator = null, \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsType $packageServiceOptions = null, \Ups_ship\UPSshipStruct\Ups_shipCommodityType $commodity = null, \Ups_ship\UPSshipStruct\Ups_shipHazMatPackageInformationType $hazMatPackageInformation = null, \Ups_ship\UPSshipStruct\Ups_shipCodeDescriptionType $simpleRate = null, \Ups_ship\UPSshipStruct\Ups_shipUPSPremierType $uPSPremier = null, $oversizeIndicator = null, $minimumBillableWeightIndicator = null)
    {
        $this
            ->setDescription($description)
            ->setPalletDescription($palletDescription)
            ->setNumOfPieces($numOfPieces)
            ->setUnitPrice($unitPrice)
            ->setPackaging($packaging)
            ->setDimensions($dimensions)
            ->setDimWeight($dimWeight)
            ->setPackageWeight($packageWeight)
            ->setLargePackageIndicator($largePackageIndicator)
            ->setReferenceNumber($referenceNumber)
            ->setAdditionalHandlingIndicator($additionalHandlingIndicator)
            ->setPackageServiceOptions($packageServiceOptions)
            ->setCommodity($commodity)
            ->setHazMatPackageInformation($hazMatPackageInformation)
            ->setSimpleRate($simpleRate)
            ->setUPSPremier($uPSPremier)
            ->setOversizeIndicator($oversizeIndicator)
            ->setMinimumBillableWeightIndicator($minimumBillableWeightIndicator);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get PalletDescription value
     * @return string|null
     */
    public function getPalletDescription()
    {
        return $this->PalletDescription;
    }
    /**
     * Set PalletDescription value
     * @param string $palletDescription
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageType
     */
    public function setPalletDescription($palletDescription = null)
    {
        // validation for constraint: string
        if (!is_null($palletDescription) && !is_string($palletDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($palletDescription, true), gettype($palletDescription)), __LINE__);
        }
        $this->PalletDescription = $palletDescription;
        return $this;
    }
    /**
     * Get NumOfPieces value
     * @return string|null
     */
    public function getNumOfPieces()
    {
        return $this->NumOfPieces;
    }
    /**
     * Set NumOfPieces value
     * @param string $numOfPieces
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageType
     */
    public function setNumOfPieces($numOfPieces = null)
    {
        // validation for constraint: string
        if (!is_null($numOfPieces) && !is_string($numOfPieces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numOfPieces, true), gettype($numOfPieces)), __LINE__);
        }
        $this->NumOfPieces = $numOfPieces;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return string|null
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param string $unitPrice
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageType
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: string
        if (!is_null($unitPrice) && !is_string($unitPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get Packaging value
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackagingType|null
     */
    public function getPackaging()
    {
        return $this->Packaging;
    }
    /**
     * Set Packaging value
     * @param \Ups_ship\UPSshipStruct\Ups_shipPackagingType $packaging
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageType
     */
    public function setPackaging(\Ups_ship\UPSshipStruct\Ups_shipPackagingType $packaging = null)
    {
        $this->Packaging = $packaging;
        return $this;
    }
    /**
     * Get Dimensions value
     * @return \Ups_ship\UPSshipStruct\Ups_shipDimensionsType|null
     */
    public function getDimensions()
    {
        return $this->Dimensions;
    }
    /**
     * Set Dimensions value
     * @param \Ups_ship\UPSshipStruct\Ups_shipDimensionsType $dimensions
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageType
     */
    public function setDimensions(\Ups_ship\UPSshipStruct\Ups_shipDimensionsType $dimensions = null)
    {
        $this->Dimensions = $dimensions;
        return $this;
    }
    /**
     * Get DimWeight value
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageWeightType|null
     */
    public function getDimWeight()
    {
        return $this->DimWeight;
    }
    /**
     * Set DimWeight value
     * @param \Ups_ship\UPSshipStruct\Ups_shipPackageWeightType $dimWeight
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageType
     */
    public function setDimWeight(\Ups_ship\UPSshipStruct\Ups_shipPackageWeightType $dimWeight = null)
    {
        $this->DimWeight = $dimWeight;
        return $this;
    }
    /**
     * Get PackageWeight value
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageWeightType|null
     */
    public function getPackageWeight()
    {
        return $this->PackageWeight;
    }
    /**
     * Set PackageWeight value
     * @param \Ups_ship\UPSshipStruct\Ups_shipPackageWeightType $packageWeight
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageType
     */
    public function setPackageWeight(\Ups_ship\UPSshipStruct\Ups_shipPackageWeightType $packageWeight = null)
    {
        $this->PackageWeight = $packageWeight;
        return $this;
    }
    /**
     * Get LargePackageIndicator value
     * @return string|null
     */
    public function getLargePackageIndicator()
    {
        return $this->LargePackageIndicator;
    }
    /**
     * Set LargePackageIndicator value
     * @param string $largePackageIndicator
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageType
     */
    public function setLargePackageIndicator($largePackageIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($largePackageIndicator) && !is_string($largePackageIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($largePackageIndicator, true), gettype($largePackageIndicator)), __LINE__);
        }
        $this->LargePackageIndicator = $largePackageIndicator;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return \Ups_ship\UPSshipStruct\Ups_shipReferenceNumberType[]|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setReferenceNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferenceNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceNumberForArrayConstraintsFromSetReferenceNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypeReferenceNumberItem) {
            // validation for constraint: itemType
            if (!$packageTypeReferenceNumberItem instanceof \Ups_ship\UPSshipStruct\Ups_shipReferenceNumberType) {
                $invalidValues[] = is_object($packageTypeReferenceNumberItem) ? get_class($packageTypeReferenceNumberItem) : sprintf('%s(%s)', gettype($packageTypeReferenceNumberItem), var_export($packageTypeReferenceNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReferenceNumber property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipReferenceNumberType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReferenceNumber value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipReferenceNumberType[] $referenceNumber
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageType
     */
    public function setReferenceNumber(array $referenceNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($referenceNumberArrayErrorMessage = self::validateReferenceNumberForArrayConstraintsFromSetReferenceNumber($referenceNumber))) {
            throw new \InvalidArgumentException($referenceNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($referenceNumber) && count($referenceNumber) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Add item to ReferenceNumber value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipReferenceNumberType $item
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageType
     */
    public function addToReferenceNumber(\Ups_ship\UPSshipStruct\Ups_shipReferenceNumberType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_ship\UPSshipStruct\Ups_shipReferenceNumberType) {
            throw new \InvalidArgumentException(sprintf('The ReferenceNumber property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipReferenceNumberType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->ReferenceNumber) && count($this->ReferenceNumber) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->ReferenceNumber)), __LINE__);
        }
        $this->ReferenceNumber[] = $item;
        return $this;
    }
    /**
     * Get AdditionalHandlingIndicator value
     * @return string|null
     */
    public function getAdditionalHandlingIndicator()
    {
        return $this->AdditionalHandlingIndicator;
    }
    /**
     * Set AdditionalHandlingIndicator value
     * @param string $additionalHandlingIndicator
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageType
     */
    public function setAdditionalHandlingIndicator($additionalHandlingIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($additionalHandlingIndicator) && !is_string($additionalHandlingIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalHandlingIndicator, true), gettype($additionalHandlingIndicator)), __LINE__);
        }
        $this->AdditionalHandlingIndicator = $additionalHandlingIndicator;
        return $this;
    }
    /**
     * Get PackageServiceOptions value
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsType|null
     */
    public function getPackageServiceOptions()
    {
        return $this->PackageServiceOptions;
    }
    /**
     * Set PackageServiceOptions value
     * @param \Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsType $packageServiceOptions
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageType
     */
    public function setPackageServiceOptions(\Ups_ship\UPSshipStruct\Ups_shipPackageServiceOptionsType $packageServiceOptions = null)
    {
        $this->PackageServiceOptions = $packageServiceOptions;
        return $this;
    }
    /**
     * Get Commodity value
     * @return \Ups_ship\UPSshipStruct\Ups_shipCommodityType|null
     */
    public function getCommodity()
    {
        return $this->Commodity;
    }
    /**
     * Set Commodity value
     * @param \Ups_ship\UPSshipStruct\Ups_shipCommodityType $commodity
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageType
     */
    public function setCommodity(\Ups_ship\UPSshipStruct\Ups_shipCommodityType $commodity = null)
    {
        $this->Commodity = $commodity;
        return $this;
    }
    /**
     * Get HazMatPackageInformation value
     * @return \Ups_ship\UPSshipStruct\Ups_shipHazMatPackageInformationType|null
     */
    public function getHazMatPackageInformation()
    {
        return $this->HazMatPackageInformation;
    }
    /**
     * Set HazMatPackageInformation value
     * @param \Ups_ship\UPSshipStruct\Ups_shipHazMatPackageInformationType $hazMatPackageInformation
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageType
     */
    public function setHazMatPackageInformation(\Ups_ship\UPSshipStruct\Ups_shipHazMatPackageInformationType $hazMatPackageInformation = null)
    {
        $this->HazMatPackageInformation = $hazMatPackageInformation;
        return $this;
    }
    /**
     * Get SimpleRate value
     * @return \Ups_ship\UPSshipStruct\Ups_shipCodeDescriptionType|null
     */
    public function getSimpleRate()
    {
        return $this->SimpleRate;
    }
    /**
     * Set SimpleRate value
     * @param \Ups_ship\UPSshipStruct\Ups_shipCodeDescriptionType $simpleRate
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageType
     */
    public function setSimpleRate(\Ups_ship\UPSshipStruct\Ups_shipCodeDescriptionType $simpleRate = null)
    {
        $this->SimpleRate = $simpleRate;
        return $this;
    }
    /**
     * Get UPSPremier value
     * @return \Ups_ship\UPSshipStruct\Ups_shipUPSPremierType|null
     */
    public function getUPSPremier()
    {
        return $this->UPSPremier;
    }
    /**
     * Set UPSPremier value
     * @param \Ups_ship\UPSshipStruct\Ups_shipUPSPremierType $uPSPremier
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageType
     */
    public function setUPSPremier(\Ups_ship\UPSshipStruct\Ups_shipUPSPremierType $uPSPremier = null)
    {
        $this->UPSPremier = $uPSPremier;
        return $this;
    }
    /**
     * Get OversizeIndicator value
     * @return string|null
     */
    public function getOversizeIndicator()
    {
        return $this->OversizeIndicator;
    }
    /**
     * Set OversizeIndicator value
     * @param string $oversizeIndicator
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageType
     */
    public function setOversizeIndicator($oversizeIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($oversizeIndicator) && !is_string($oversizeIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oversizeIndicator, true), gettype($oversizeIndicator)), __LINE__);
        }
        $this->OversizeIndicator = $oversizeIndicator;
        return $this;
    }
    /**
     * Get MinimumBillableWeightIndicator value
     * @return string|null
     */
    public function getMinimumBillableWeightIndicator()
    {
        return $this->MinimumBillableWeightIndicator;
    }
    /**
     * Set MinimumBillableWeightIndicator value
     * @param string $minimumBillableWeightIndicator
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageType
     */
    public function setMinimumBillableWeightIndicator($minimumBillableWeightIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($minimumBillableWeightIndicator) && !is_string($minimumBillableWeightIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumBillableWeightIndicator, true), gettype($minimumBillableWeightIndicator)), __LINE__);
        }
        $this->MinimumBillableWeightIndicator = $minimumBillableWeightIndicator;
        return $this;
    }
}
