<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelSpecificationType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 * @Author iBen
 */
class Ups_shipLabelSpecificationType extends AbstractStructBase
{
    /**
     * The LabelImageFormat
     * @var \Ups_ship\UPSshipStruct\Ups_shipLabelImageFormatType
     */
    public $LabelImageFormat;
    /**
     * The HTTPUserAgent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HTTPUserAgent;
    /**
     * The LabelStockSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipLabelStockSizeType
     */
    public $LabelStockSize;
    /**
     * The Instruction
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipInstructionCodeDescriptionType[]
     */
    public $Instruction;
    /**
     * The CharacterSet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CharacterSet;
    /**
     * Constructor method for LabelSpecificationType
     * @uses Ups_shipLabelSpecificationType::setLabelImageFormat()
     * @uses Ups_shipLabelSpecificationType::setHTTPUserAgent()
     * @uses Ups_shipLabelSpecificationType::setLabelStockSize()
     * @uses Ups_shipLabelSpecificationType::setInstruction()
     * @uses Ups_shipLabelSpecificationType::setCharacterSet()
     * @param \Ups_ship\UPSshipStruct\Ups_shipLabelImageFormatType $labelImageFormat
     * @param string $hTTPUserAgent
     * @param \Ups_ship\UPSshipStruct\Ups_shipLabelStockSizeType $labelStockSize
     * @param \Ups_ship\UPSshipStruct\Ups_shipInstructionCodeDescriptionType[] $instruction
     * @param string $characterSet
     */
    public function __construct(\Ups_ship\UPSshipStruct\Ups_shipLabelImageFormatType $labelImageFormat = null, $hTTPUserAgent = null, \Ups_ship\UPSshipStruct\Ups_shipLabelStockSizeType $labelStockSize = null, array $instruction = array(), $characterSet = null)
    {
        $this
            ->setLabelImageFormat($labelImageFormat)
            ->setHTTPUserAgent($hTTPUserAgent)
            ->setLabelStockSize($labelStockSize)
            ->setInstruction($instruction)
            ->setCharacterSet($characterSet);
    }
    /**
     * Get LabelImageFormat value
     * @return \Ups_ship\UPSshipStruct\Ups_shipLabelImageFormatType|null
     */
    public function getLabelImageFormat()
    {
        return $this->LabelImageFormat;
    }
    /**
     * Set LabelImageFormat value
     * @param \Ups_ship\UPSshipStruct\Ups_shipLabelImageFormatType $labelImageFormat
     * @return \Ups_ship\UPSshipStruct\Ups_shipLabelSpecificationType
     */
    public function setLabelImageFormat(\Ups_ship\UPSshipStruct\Ups_shipLabelImageFormatType $labelImageFormat = null)
    {
        $this->LabelImageFormat = $labelImageFormat;
        return $this;
    }
    /**
     * Get HTTPUserAgent value
     * @return string|null
     */
    public function getHTTPUserAgent()
    {
        return $this->HTTPUserAgent;
    }
    /**
     * Set HTTPUserAgent value
     * @param string $hTTPUserAgent
     * @return \Ups_ship\UPSshipStruct\Ups_shipLabelSpecificationType
     */
    public function setHTTPUserAgent($hTTPUserAgent = null)
    {
        // validation for constraint: string
        if (!is_null($hTTPUserAgent) && !is_string($hTTPUserAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hTTPUserAgent, true), gettype($hTTPUserAgent)), __LINE__);
        }
        $this->HTTPUserAgent = $hTTPUserAgent;
        return $this;
    }
    /**
     * Get LabelStockSize value
     * @return \Ups_ship\UPSshipStruct\Ups_shipLabelStockSizeType|null
     */
    public function getLabelStockSize()
    {
        return $this->LabelStockSize;
    }
    /**
     * Set LabelStockSize value
     * @param \Ups_ship\UPSshipStruct\Ups_shipLabelStockSizeType $labelStockSize
     * @return \Ups_ship\UPSshipStruct\Ups_shipLabelSpecificationType
     */
    public function setLabelStockSize(\Ups_ship\UPSshipStruct\Ups_shipLabelStockSizeType $labelStockSize = null)
    {
        $this->LabelStockSize = $labelStockSize;
        return $this;
    }
    /**
     * Get Instruction value
     * @return \Ups_ship\UPSshipStruct\Ups_shipInstructionCodeDescriptionType[]|null
     */
    public function getInstruction()
    {
        return $this->Instruction;
    }
    /**
     * This method is responsible for validating the values passed to the setInstruction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInstruction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInstructionForArrayConstraintsFromSetInstruction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $labelSpecificationTypeInstructionItem) {
            // validation for constraint: itemType
            if (!$labelSpecificationTypeInstructionItem instanceof \Ups_ship\UPSshipStruct\Ups_shipInstructionCodeDescriptionType) {
                $invalidValues[] = is_object($labelSpecificationTypeInstructionItem) ? get_class($labelSpecificationTypeInstructionItem) : sprintf('%s(%s)', gettype($labelSpecificationTypeInstructionItem), var_export($labelSpecificationTypeInstructionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Instruction property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipInstructionCodeDescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Instruction value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipInstructionCodeDescriptionType[] $instruction
     * @return \Ups_ship\UPSshipStruct\Ups_shipLabelSpecificationType
     */
    public function setInstruction(array $instruction = array())
    {
        // validation for constraint: array
        if ('' !== ($instructionArrayErrorMessage = self::validateInstructionForArrayConstraintsFromSetInstruction($instruction))) {
            throw new \InvalidArgumentException($instructionArrayErrorMessage, __LINE__);
        }
        $this->Instruction = $instruction;
        return $this;
    }
    /**
     * Add item to Instruction value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipInstructionCodeDescriptionType $item
     * @return \Ups_ship\UPSshipStruct\Ups_shipLabelSpecificationType
     */
    public function addToInstruction(\Ups_ship\UPSshipStruct\Ups_shipInstructionCodeDescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_ship\UPSshipStruct\Ups_shipInstructionCodeDescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Instruction property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipInstructionCodeDescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Instruction[] = $item;
        return $this;
    }
    /**
     * Get CharacterSet value
     * @return string|null
     */
    public function getCharacterSet()
    {
        return $this->CharacterSet;
    }
    /**
     * Set CharacterSet value
     * @param string $characterSet
     * @return \Ups_ship\UPSshipStruct\Ups_shipLabelSpecificationType
     */
    public function setCharacterSet($characterSet = null)
    {
        // validation for constraint: string
        if (!is_null($characterSet) && !is_string($characterSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($characterSet, true), gettype($characterSet)), __LINE__);
        }
        $this->CharacterSet = $characterSet;
        return $this;
    }
}
