<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HandlingUnitsResponseType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 * @Author iBen
 */
class Ups_shipHandlingUnitsResponseType extends AbstractStructBase
{
    /**
     * The Quantity
     * @var string
     */
    public $Quantity;
    /**
     * The Type
     * @var \Ups_ship\UPSshipStruct\Ups_shipShipUnitOfMeasurementType
     */
    public $Type;
    /**
     * The Dimensions
     * @var \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsDimensionsType
     */
    public $Dimensions;
    /**
     * The AdjustedHeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipAdjustedHeightType
     */
    public $AdjustedHeight;
    /**
     * Constructor method for HandlingUnitsResponseType
     * @uses Ups_shipHandlingUnitsResponseType::setQuantity()
     * @uses Ups_shipHandlingUnitsResponseType::setType()
     * @uses Ups_shipHandlingUnitsResponseType::setDimensions()
     * @uses Ups_shipHandlingUnitsResponseType::setAdjustedHeight()
     * @param string $quantity
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipUnitOfMeasurementType $type
     * @param \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsDimensionsType $dimensions
     * @param \Ups_ship\UPSshipStruct\Ups_shipAdjustedHeightType $adjustedHeight
     */
    public function __construct($quantity = null, \Ups_ship\UPSshipStruct\Ups_shipShipUnitOfMeasurementType $type = null, \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsDimensionsType $dimensions = null, \Ups_ship\UPSshipStruct\Ups_shipAdjustedHeightType $adjustedHeight = null)
    {
        $this
            ->setQuantity($quantity)
            ->setType($type)
            ->setDimensions($dimensions)
            ->setAdjustedHeight($adjustedHeight);
    }
    /**
     * Get Quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsResponseType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Type value
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipUnitOfMeasurementType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipUnitOfMeasurementType $type
     * @return \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsResponseType
     */
    public function setType(\Ups_ship\UPSshipStruct\Ups_shipShipUnitOfMeasurementType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Dimensions value
     * @return \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsDimensionsType|null
     */
    public function getDimensions()
    {
        return $this->Dimensions;
    }
    /**
     * Set Dimensions value
     * @param \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsDimensionsType $dimensions
     * @return \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsResponseType
     */
    public function setDimensions(\Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsDimensionsType $dimensions = null)
    {
        $this->Dimensions = $dimensions;
        return $this;
    }
    /**
     * Get AdjustedHeight value
     * @return \Ups_ship\UPSshipStruct\Ups_shipAdjustedHeightType|null
     */
    public function getAdjustedHeight()
    {
        return $this->AdjustedHeight;
    }
    /**
     * Set AdjustedHeight value
     * @param \Ups_ship\UPSshipStruct\Ups_shipAdjustedHeightType $adjustedHeight
     * @return \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsResponseType
     */
    public function setAdjustedHeight(\Ups_ship\UPSshipStruct\Ups_shipAdjustedHeightType $adjustedHeight = null)
    {
        $this->AdjustedHeight = $adjustedHeight;
        return $this;
    }
}
