<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ForwardAgentType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 * @Author iBen
 */
class Ups_shipForwardAgentType extends AbstractStructBase
{
    /**
     * The CompanyName
     * @var string
     */
    public $CompanyName;
    /**
     * The TaxIdentificationNumber
     * @var string
     */
    public $TaxIdentificationNumber;
    /**
     * The Address
     * @var \Ups_ship\UPSshipStruct\Ups_shipAddressType
     */
    public $Address;
    /**
     * Constructor method for ForwardAgentType
     * @uses Ups_shipForwardAgentType::setCompanyName()
     * @uses Ups_shipForwardAgentType::setTaxIdentificationNumber()
     * @uses Ups_shipForwardAgentType::setAddress()
     * @param string $companyName
     * @param string $taxIdentificationNumber
     * @param \Ups_ship\UPSshipStruct\Ups_shipAddressType $address
     */
    public function __construct($companyName = null, $taxIdentificationNumber = null, \Ups_ship\UPSshipStruct\Ups_shipAddressType $address = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setTaxIdentificationNumber($taxIdentificationNumber)
            ->setAddress($address);
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \Ups_ship\UPSshipStruct\Ups_shipForwardAgentType
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get TaxIdentificationNumber value
     * @return string|null
     */
    public function getTaxIdentificationNumber()
    {
        return $this->TaxIdentificationNumber;
    }
    /**
     * Set TaxIdentificationNumber value
     * @param string $taxIdentificationNumber
     * @return \Ups_ship\UPSshipStruct\Ups_shipForwardAgentType
     */
    public function setTaxIdentificationNumber($taxIdentificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxIdentificationNumber) && !is_string($taxIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxIdentificationNumber, true), gettype($taxIdentificationNumber)), __LINE__);
        }
        $this->TaxIdentificationNumber = $taxIdentificationNumber;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups_ship\UPSshipStruct\Ups_shipAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups_ship\UPSshipStruct\Ups_shipAddressType $address
     * @return \Ups_ship\UPSshipStruct\Ups_shipForwardAgentType
     */
    public function setAddress(\Ups_ship\UPSshipStruct\Ups_shipAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
