<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UltimateConsigneeType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 * @Author iBen
 */
class Ups_shipUltimateConsigneeType extends AbstractStructBase
{
    /**
     * The CompanyName
     * @var string
     */
    public $CompanyName;
    /**
     * The Address
     * @var \Ups_ship\UPSshipStruct\Ups_shipAddressType
     */
    public $Address;
    /**
     * The UltimateConsigneeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipUltimateConsigneeTypeType
     */
    public $UltimateConsigneeType;
    /**
     * Constructor method for UltimateConsigneeType
     * @uses Ups_shipUltimateConsigneeType::setCompanyName()
     * @uses Ups_shipUltimateConsigneeType::setAddress()
     * @uses Ups_shipUltimateConsigneeType::setUltimateConsigneeType()
     * @param string $companyName
     * @param \Ups_ship\UPSshipStruct\Ups_shipAddressType $address
     * @param \Ups_ship\UPSshipStruct\Ups_shipUltimateConsigneeTypeType $ultimateConsigneeType
     */
    public function __construct($companyName = null, \Ups_ship\UPSshipStruct\Ups_shipAddressType $address = null, \Ups_ship\UPSshipStruct\Ups_shipUltimateConsigneeTypeType $ultimateConsigneeType = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setAddress($address)
            ->setUltimateConsigneeType($ultimateConsigneeType);
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \Ups_ship\UPSshipStruct\Ups_shipUltimateConsigneeType
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups_ship\UPSshipStruct\Ups_shipAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups_ship\UPSshipStruct\Ups_shipAddressType $address
     * @return \Ups_ship\UPSshipStruct\Ups_shipUltimateConsigneeType
     */
    public function setAddress(\Ups_ship\UPSshipStruct\Ups_shipAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get UltimateConsigneeType value
     * @return \Ups_ship\UPSshipStruct\Ups_shipUltimateConsigneeTypeType|null
     */
    public function getUltimateConsigneeType()
    {
        return $this->UltimateConsigneeType;
    }
    /**
     * Set UltimateConsigneeType value
     * @param \Ups_ship\UPSshipStruct\Ups_shipUltimateConsigneeTypeType $ultimateConsigneeType
     * @return \Ups_ship\UPSshipStruct\Ups_shipUltimateConsigneeType
     */
    public function setUltimateConsigneeType(\Ups_ship\UPSshipStruct\Ups_shipUltimateConsigneeTypeType $ultimateConsigneeType = null)
    {
        $this->UltimateConsigneeType = $ultimateConsigneeType;
        return $this;
    }
}
