<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SoldToType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 * @Author iBen
 */
class Ups_shipSoldToType extends AbstractStructBase
{
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The AttentionName
     * @var string
     */
    public $AttentionName;
    /**
     * The TaxIdentificationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TaxIdentificationNumber;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipPhoneType
     */
    public $Phone;
    /**
     * The Option
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Option;
    /**
     * The Address
     * @var \Ups_ship\UPSshipStruct\Ups_shipAddressType
     */
    public $Address;
    /**
     * The EMailAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EMailAddress;
    /**
     * Constructor method for SoldToType
     * @uses Ups_shipSoldToType::setName()
     * @uses Ups_shipSoldToType::setAttentionName()
     * @uses Ups_shipSoldToType::setTaxIdentificationNumber()
     * @uses Ups_shipSoldToType::setPhone()
     * @uses Ups_shipSoldToType::setOption()
     * @uses Ups_shipSoldToType::setAddress()
     * @uses Ups_shipSoldToType::setEMailAddress()
     * @param string $name
     * @param string $attentionName
     * @param string $taxIdentificationNumber
     * @param \Ups_ship\UPSshipStruct\Ups_shipPhoneType $phone
     * @param string $option
     * @param \Ups_ship\UPSshipStruct\Ups_shipAddressType $address
     * @param string $eMailAddress
     */
    public function __construct($name = null, $attentionName = null, $taxIdentificationNumber = null, \Ups_ship\UPSshipStruct\Ups_shipPhoneType $phone = null, $option = null, \Ups_ship\UPSshipStruct\Ups_shipAddressType $address = null, $eMailAddress = null)
    {
        $this
            ->setName($name)
            ->setAttentionName($attentionName)
            ->setTaxIdentificationNumber($taxIdentificationNumber)
            ->setPhone($phone)
            ->setOption($option)
            ->setAddress($address)
            ->setEMailAddress($eMailAddress);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Ups_ship\UPSshipStruct\Ups_shipSoldToType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get AttentionName value
     * @return string|null
     */
    public function getAttentionName()
    {
        return $this->AttentionName;
    }
    /**
     * Set AttentionName value
     * @param string $attentionName
     * @return \Ups_ship\UPSshipStruct\Ups_shipSoldToType
     */
    public function setAttentionName($attentionName = null)
    {
        // validation for constraint: string
        if (!is_null($attentionName) && !is_string($attentionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attentionName, true), gettype($attentionName)), __LINE__);
        }
        $this->AttentionName = $attentionName;
        return $this;
    }
    /**
     * Get TaxIdentificationNumber value
     * @return string|null
     */
    public function getTaxIdentificationNumber()
    {
        return $this->TaxIdentificationNumber;
    }
    /**
     * Set TaxIdentificationNumber value
     * @param string $taxIdentificationNumber
     * @return \Ups_ship\UPSshipStruct\Ups_shipSoldToType
     */
    public function setTaxIdentificationNumber($taxIdentificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxIdentificationNumber) && !is_string($taxIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxIdentificationNumber, true), gettype($taxIdentificationNumber)), __LINE__);
        }
        $this->TaxIdentificationNumber = $taxIdentificationNumber;
        return $this;
    }
    /**
     * Get Phone value
     * @return \Ups_ship\UPSshipStruct\Ups_shipPhoneType|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param \Ups_ship\UPSshipStruct\Ups_shipPhoneType $phone
     * @return \Ups_ship\UPSshipStruct\Ups_shipSoldToType
     */
    public function setPhone(\Ups_ship\UPSshipStruct\Ups_shipPhoneType $phone = null)
    {
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Option value
     * @return string|null
     */
    public function getOption()
    {
        return $this->Option;
    }
    /**
     * Set Option value
     * @param string $option
     * @return \Ups_ship\UPSshipStruct\Ups_shipSoldToType
     */
    public function setOption($option = null)
    {
        // validation for constraint: string
        if (!is_null($option) && !is_string($option)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($option, true), gettype($option)), __LINE__);
        }
        $this->Option = $option;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups_ship\UPSshipStruct\Ups_shipAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups_ship\UPSshipStruct\Ups_shipAddressType $address
     * @return \Ups_ship\UPSshipStruct\Ups_shipSoldToType
     */
    public function setAddress(\Ups_ship\UPSshipStruct\Ups_shipAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get EMailAddress value
     * @return string|null
     */
    public function getEMailAddress()
    {
        return $this->EMailAddress;
    }
    /**
     * Set EMailAddress value
     * @param string $eMailAddress
     * @return \Ups_ship\UPSshipStruct\Ups_shipSoldToType
     */
    public function setEMailAddress($eMailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($eMailAddress) && !is_string($eMailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMailAddress, true), gettype($eMailAddress)), __LINE__);
        }
        $this->EMailAddress = $eMailAddress;
        return $this;
    }
}
