<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipAcceptRequest UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 * @Author iBen
 */
class Ups_shipShipAcceptRequest extends AbstractStructBase
{
    /**
     * The Request
     * Meta information extracted from the WSDL
     * - ref: common:Request
     * @var \Ups_ship\UPSshipStruct\Ups_shipRequestType
     */
    public $Request;
    /**
     * The ShipmentDigest
     * @var string
     */
    public $ShipmentDigest;
    /**
     * Constructor method for ShipAcceptRequest
     * @uses Ups_shipShipAcceptRequest::setRequest()
     * @uses Ups_shipShipAcceptRequest::setShipmentDigest()
     * @param \Ups_ship\UPSshipStruct\Ups_shipRequestType $request
     * @param string $shipmentDigest
     */
    public function __construct(\Ups_ship\UPSshipStruct\Ups_shipRequestType $request = null, $shipmentDigest = null)
    {
        $this
            ->setRequest($request)
            ->setShipmentDigest($shipmentDigest);
    }
    /**
     * Get Request value
     * @return \Ups_ship\UPSshipStruct\Ups_shipRequestType|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \Ups_ship\UPSshipStruct\Ups_shipRequestType $request
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipAcceptRequest
     */
    public function setRequest(\Ups_ship\UPSshipStruct\Ups_shipRequestType $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get ShipmentDigest value
     * @return string|null
     */
    public function getShipmentDigest()
    {
        return $this->ShipmentDigest;
    }
    /**
     * Set ShipmentDigest value
     * @param string $shipmentDigest
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipAcceptRequest
     */
    public function setShipmentDigest($shipmentDigest = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentDigest) && !is_string($shipmentDigest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentDigest, true), gettype($shipmentDigest)), __LINE__);
        }
        $this->ShipmentDigest = $shipmentDigest;
        return $this;
    }
}
