<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageAssociatedType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 * @Author iBen
 */
class Ups_shipPackageAssociatedType extends AbstractStructBase
{
    /**
     * The PackageNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PackageNumber;
    /**
     * The ProductAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ProductAmount;
    /**
     * Constructor method for PackageAssociatedType
     * @uses Ups_shipPackageAssociatedType::setPackageNumber()
     * @uses Ups_shipPackageAssociatedType::setProductAmount()
     * @param string $packageNumber
     * @param string $productAmount
     */
    public function __construct($packageNumber = null, $productAmount = null)
    {
        $this
            ->setPackageNumber($packageNumber)
            ->setProductAmount($productAmount);
    }
    /**
     * Get PackageNumber value
     * @return string|null
     */
    public function getPackageNumber()
    {
        return $this->PackageNumber;
    }
    /**
     * Set PackageNumber value
     * @param string $packageNumber
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageAssociatedType
     */
    public function setPackageNumber($packageNumber = null)
    {
        // validation for constraint: string
        if (!is_null($packageNumber) && !is_string($packageNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageNumber, true), gettype($packageNumber)), __LINE__);
        }
        $this->PackageNumber = $packageNumber;
        return $this;
    }
    /**
     * Get ProductAmount value
     * @return string|null
     */
    public function getProductAmount()
    {
        return $this->ProductAmount;
    }
    /**
     * Set ProductAmount value
     * @param string $productAmount
     * @return \Ups_ship\UPSshipStruct\Ups_shipPackageAssociatedType
     */
    public function setProductAmount($productAmount = null)
    {
        // validation for constraint: string
        if (!is_null($productAmount) && !is_string($productAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productAmount, true), gettype($productAmount)), __LINE__);
        }
        $this->ProductAmount = $productAmount;
        return $this;
    }
}
