<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommodityType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 * @Author iBen
 */
class Ups_shipCommodityType extends AbstractStructBase
{
    /**
     * The FreightClass
     * @var string
     */
    public $FreightClass;
    /**
     * The NMFC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipNMFCType
     */
    public $NMFC;
    /**
     * Constructor method for CommodityType
     * @uses Ups_shipCommodityType::setFreightClass()
     * @uses Ups_shipCommodityType::setNMFC()
     * @param string $freightClass
     * @param \Ups_ship\UPSshipStruct\Ups_shipNMFCType $nMFC
     */
    public function __construct($freightClass = null, \Ups_ship\UPSshipStruct\Ups_shipNMFCType $nMFC = null)
    {
        $this
            ->setFreightClass($freightClass)
            ->setNMFC($nMFC);
    }
    /**
     * Get FreightClass value
     * @return string|null
     */
    public function getFreightClass()
    {
        return $this->FreightClass;
    }
    /**
     * Set FreightClass value
     * @param string $freightClass
     * @return \Ups_ship\UPSshipStruct\Ups_shipCommodityType
     */
    public function setFreightClass($freightClass = null)
    {
        // validation for constraint: string
        if (!is_null($freightClass) && !is_string($freightClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($freightClass, true), gettype($freightClass)), __LINE__);
        }
        $this->FreightClass = $freightClass;
        return $this;
    }
    /**
     * Get NMFC value
     * @return \Ups_ship\UPSshipStruct\Ups_shipNMFCType|null
     */
    public function getNMFC()
    {
        return $this->NMFC;
    }
    /**
     * Set NMFC value
     * @param \Ups_ship\UPSshipStruct\Ups_shipNMFCType $nMFC
     * @return \Ups_ship\UPSshipStruct\Ups_shipCommodityType
     */
    public function setNMFC(\Ups_ship\UPSshipStruct\Ups_shipNMFCType $nMFC = null)
    {
        $this->NMFC = $nMFC;
        return $this;
    }
}
