<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillThirdPartyChargeType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 * @Author iBen
 */
class Ups_shipBillThirdPartyChargeType extends AbstractStructBase
{
    /**
     * The AccountNumber
     * @var string
     */
    public $AccountNumber;
    /**
     * The Address
     * @var \Ups_ship\UPSshipStruct\Ups_shipAccountAddressType
     */
    public $Address;
    /**
     * Constructor method for BillThirdPartyChargeType
     * @uses Ups_shipBillThirdPartyChargeType::setAccountNumber()
     * @uses Ups_shipBillThirdPartyChargeType::setAddress()
     * @param string $accountNumber
     * @param \Ups_ship\UPSshipStruct\Ups_shipAccountAddressType $address
     */
    public function __construct($accountNumber = null, \Ups_ship\UPSshipStruct\Ups_shipAccountAddressType $address = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setAddress($address);
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \Ups_ship\UPSshipStruct\Ups_shipBillThirdPartyChargeType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups_ship\UPSshipStruct\Ups_shipAccountAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups_ship\UPSshipStruct\Ups_shipAccountAddressType $address
     * @return \Ups_ship\UPSshipStruct\Ups_shipBillThirdPartyChargeType
     */
    public function setAddress(\Ups_ship\UPSshipStruct\Ups_shipAccountAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
