<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillReceiverType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 * @Author iBen
 */
class Ups_shipBillReceiverType extends AbstractStructBase
{
    /**
     * The AccountNumber
     * @var string
     */
    public $AccountNumber;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipBillReceiverAddressType
     */
    public $Address;
    /**
     * Constructor method for BillReceiverType
     * @uses Ups_shipBillReceiverType::setAccountNumber()
     * @uses Ups_shipBillReceiverType::setAddress()
     * @param string $accountNumber
     * @param \Ups_ship\UPSshipStruct\Ups_shipBillReceiverAddressType $address
     */
    public function __construct($accountNumber = null, \Ups_ship\UPSshipStruct\Ups_shipBillReceiverAddressType $address = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setAddress($address);
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \Ups_ship\UPSshipStruct\Ups_shipBillReceiverType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups_ship\UPSshipStruct\Ups_shipBillReceiverAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups_ship\UPSshipStruct\Ups_shipBillReceiverAddressType $address
     * @return \Ups_ship\UPSshipStruct\Ups_shipBillReceiverType
     */
    public function setAddress(\Ups_ship\UPSshipStruct\Ups_shipBillReceiverAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
