<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipConfirmRequest UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 * @Author iBen
 */
class Ups_shipShipConfirmRequest extends AbstractStructBase
{
    /**
     * The Request
     * Meta information extracted from the WSDL
     * - ref: common:Request
     * @var \Ups_ship\UPSshipStruct\Ups_shipRequestType
     */
    public $Request;
    /**
     * The Shipment
     * @var \Ups_ship\UPSshipStruct\Ups_shipShipmentType
     */
    public $Shipment;
    /**
     * The LabelSpecification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipLabelSpecificationType
     */
    public $LabelSpecification;
    /**
     * The ReceiptSpecification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipReceiptSpecificationType
     */
    public $ReceiptSpecification;
    /**
     * Constructor method for ShipConfirmRequest
     * @uses Ups_shipShipConfirmRequest::setRequest()
     * @uses Ups_shipShipConfirmRequest::setShipment()
     * @uses Ups_shipShipConfirmRequest::setLabelSpecification()
     * @uses Ups_shipShipConfirmRequest::setReceiptSpecification()
     * @param \Ups_ship\UPSshipStruct\Ups_shipRequestType $request
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipmentType $shipment
     * @param \Ups_ship\UPSshipStruct\Ups_shipLabelSpecificationType $labelSpecification
     * @param \Ups_ship\UPSshipStruct\Ups_shipReceiptSpecificationType $receiptSpecification
     */
    public function __construct(\Ups_ship\UPSshipStruct\Ups_shipRequestType $request = null, \Ups_ship\UPSshipStruct\Ups_shipShipmentType $shipment = null, \Ups_ship\UPSshipStruct\Ups_shipLabelSpecificationType $labelSpecification = null, \Ups_ship\UPSshipStruct\Ups_shipReceiptSpecificationType $receiptSpecification = null)
    {
        $this
            ->setRequest($request)
            ->setShipment($shipment)
            ->setLabelSpecification($labelSpecification)
            ->setReceiptSpecification($receiptSpecification);
    }
    /**
     * Get Request value
     * @return \Ups_ship\UPSshipStruct\Ups_shipRequestType|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \Ups_ship\UPSshipStruct\Ups_shipRequestType $request
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipConfirmRequest
     */
    public function setRequest(\Ups_ship\UPSshipStruct\Ups_shipRequestType $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get Shipment value
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipmentType|null
     */
    public function getShipment()
    {
        return $this->Shipment;
    }
    /**
     * Set Shipment value
     * @param \Ups_ship\UPSshipStruct\Ups_shipShipmentType $shipment
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipConfirmRequest
     */
    public function setShipment(\Ups_ship\UPSshipStruct\Ups_shipShipmentType $shipment = null)
    {
        $this->Shipment = $shipment;
        return $this;
    }
    /**
     * Get LabelSpecification value
     * @return \Ups_ship\UPSshipStruct\Ups_shipLabelSpecificationType|null
     */
    public function getLabelSpecification()
    {
        return $this->LabelSpecification;
    }
    /**
     * Set LabelSpecification value
     * @param \Ups_ship\UPSshipStruct\Ups_shipLabelSpecificationType $labelSpecification
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipConfirmRequest
     */
    public function setLabelSpecification(\Ups_ship\UPSshipStruct\Ups_shipLabelSpecificationType $labelSpecification = null)
    {
        $this->LabelSpecification = $labelSpecification;
        return $this;
    }
    /**
     * Get ReceiptSpecification value
     * @return \Ups_ship\UPSshipStruct\Ups_shipReceiptSpecificationType|null
     */
    public function getReceiptSpecification()
    {
        return $this->ReceiptSpecification;
    }
    /**
     * Set ReceiptSpecification value
     * @param \Ups_ship\UPSshipStruct\Ups_shipReceiptSpecificationType $receiptSpecification
     * @return \Ups_ship\UPSshipStruct\Ups_shipShipConfirmRequest
     */
    public function setReceiptSpecification(\Ups_ship\UPSshipStruct\Ups_shipReceiptSpecificationType $receiptSpecification = null)
    {
        $this->ReceiptSpecification = $receiptSpecification;
        return $this;
    }
}
