<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceAccessToken UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 * @Author iBen
 */
class Ups_shipServiceAccessToken extends AbstractStructBase
{
    /**
     * The AccessLicenseNumber
     * @var string
     */
    public $AccessLicenseNumber;
    /**
     * Constructor method for ServiceAccessToken
     * @uses Ups_shipServiceAccessToken::setAccessLicenseNumber()
     * @param string $accessLicenseNumber
     */
    public function __construct($accessLicenseNumber = null)
    {
        $this
            ->setAccessLicenseNumber($accessLicenseNumber);
    }
    /**
     * Get AccessLicenseNumber value
     * @return string|null
     */
    public function getAccessLicenseNumber()
    {
        return $this->AccessLicenseNumber;
    }
    /**
     * Set AccessLicenseNumber value
     * @param string $accessLicenseNumber
     * @return \Ups_ship\UPSshipStruct\Ups_shipServiceAccessToken
     */
    public function setAccessLicenseNumber($accessLicenseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accessLicenseNumber) && !is_string($accessLicenseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessLicenseNumber, true), gettype($accessLicenseNumber)), __LINE__);
        }
        $this->AccessLicenseNumber = $accessLicenseNumber;
        return $this;
    }
}
