<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IFChargesType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 * @Author iBen
 */
class Ups_shipIFChargesType extends AbstractStructBase
{
    /**
     * The MonetaryValue
     * @var string
     */
    public $MonetaryValue;
    /**
     * Constructor method for IFChargesType
     * @uses Ups_shipIFChargesType::setMonetaryValue()
     * @param string $monetaryValue
     */
    public function __construct($monetaryValue = null)
    {
        $this
            ->setMonetaryValue($monetaryValue);
    }
    /**
     * Get MonetaryValue value
     * @return string|null
     */
    public function getMonetaryValue()
    {
        return $this->MonetaryValue;
    }
    /**
     * Set MonetaryValue value
     * @param string $monetaryValue
     * @return \Ups_ship\UPSshipStruct\Ups_shipIFChargesType
     */
    public function setMonetaryValue($monetaryValue = null)
    {
        // validation for constraint: string
        if (!is_null($monetaryValue) && !is_string($monetaryValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monetaryValue, true), gettype($monetaryValue)), __LINE__);
        }
        $this->MonetaryValue = $monetaryValue;
        return $this;
    }
}
