<?php

namespace Ups_ship\UPSshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FRSShipmentDataType UPSshipStruct
 * @package Ups_ship
 * @subpackage Structs
 * @Author iBen
 */
class Ups_shipFRSShipmentDataType extends AbstractStructBase
{
    /**
     * The TransportationCharges
     * @var \Ups_ship\UPSshipStruct\Ups_shipTransportationChargeType
     */
    public $TransportationCharges;
    /**
     * The FreightDensityRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipFreightDensityRateType
     */
    public $FreightDensityRate;
    /**
     * The HandlingUnits
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsResponseType[]
     */
    public $HandlingUnits;
    /**
     * Constructor method for FRSShipmentDataType
     * @uses Ups_shipFRSShipmentDataType::setTransportationCharges()
     * @uses Ups_shipFRSShipmentDataType::setFreightDensityRate()
     * @uses Ups_shipFRSShipmentDataType::setHandlingUnits()
     * @param \Ups_ship\UPSshipStruct\Ups_shipTransportationChargeType $transportationCharges
     * @param \Ups_ship\UPSshipStruct\Ups_shipFreightDensityRateType $freightDensityRate
     * @param \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsResponseType[] $handlingUnits
     */
    public function __construct(\Ups_ship\UPSshipStruct\Ups_shipTransportationChargeType $transportationCharges = null, \Ups_ship\UPSshipStruct\Ups_shipFreightDensityRateType $freightDensityRate = null, array $handlingUnits = array())
    {
        $this
            ->setTransportationCharges($transportationCharges)
            ->setFreightDensityRate($freightDensityRate)
            ->setHandlingUnits($handlingUnits);
    }
    /**
     * Get TransportationCharges value
     * @return \Ups_ship\UPSshipStruct\Ups_shipTransportationChargeType|null
     */
    public function getTransportationCharges()
    {
        return $this->TransportationCharges;
    }
    /**
     * Set TransportationCharges value
     * @param \Ups_ship\UPSshipStruct\Ups_shipTransportationChargeType $transportationCharges
     * @return \Ups_ship\UPSshipStruct\Ups_shipFRSShipmentDataType
     */
    public function setTransportationCharges(\Ups_ship\UPSshipStruct\Ups_shipTransportationChargeType $transportationCharges = null)
    {
        $this->TransportationCharges = $transportationCharges;
        return $this;
    }
    /**
     * Get FreightDensityRate value
     * @return \Ups_ship\UPSshipStruct\Ups_shipFreightDensityRateType|null
     */
    public function getFreightDensityRate()
    {
        return $this->FreightDensityRate;
    }
    /**
     * Set FreightDensityRate value
     * @param \Ups_ship\UPSshipStruct\Ups_shipFreightDensityRateType $freightDensityRate
     * @return \Ups_ship\UPSshipStruct\Ups_shipFRSShipmentDataType
     */
    public function setFreightDensityRate(\Ups_ship\UPSshipStruct\Ups_shipFreightDensityRateType $freightDensityRate = null)
    {
        $this->FreightDensityRate = $freightDensityRate;
        return $this;
    }
    /**
     * Get HandlingUnits value
     * @return \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsResponseType[]|null
     */
    public function getHandlingUnits()
    {
        return $this->HandlingUnits;
    }
    /**
     * This method is responsible for validating the values passed to the setHandlingUnits method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHandlingUnits method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHandlingUnitsForArrayConstraintsFromSetHandlingUnits(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fRSShipmentDataTypeHandlingUnitsItem) {
            // validation for constraint: itemType
            if (!$fRSShipmentDataTypeHandlingUnitsItem instanceof \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsResponseType) {
                $invalidValues[] = is_object($fRSShipmentDataTypeHandlingUnitsItem) ? get_class($fRSShipmentDataTypeHandlingUnitsItem) : sprintf('%s(%s)', gettype($fRSShipmentDataTypeHandlingUnitsItem), var_export($fRSShipmentDataTypeHandlingUnitsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HandlingUnits property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsResponseType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HandlingUnits value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsResponseType[] $handlingUnits
     * @return \Ups_ship\UPSshipStruct\Ups_shipFRSShipmentDataType
     */
    public function setHandlingUnits(array $handlingUnits = array())
    {
        // validation for constraint: array
        if ('' !== ($handlingUnitsArrayErrorMessage = self::validateHandlingUnitsForArrayConstraintsFromSetHandlingUnits($handlingUnits))) {
            throw new \InvalidArgumentException($handlingUnitsArrayErrorMessage, __LINE__);
        }
        $this->HandlingUnits = $handlingUnits;
        return $this;
    }
    /**
     * Add item to HandlingUnits value
     * @throws \InvalidArgumentException
     * @param \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsResponseType $item
     * @return \Ups_ship\UPSshipStruct\Ups_shipFRSShipmentDataType
     */
    public function addToHandlingUnits(\Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsResponseType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsResponseType) {
            throw new \InvalidArgumentException(sprintf('The HandlingUnits property can only contain items of type \Ups_ship\UPSshipStruct\Ups_shipHandlingUnitsResponseType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HandlingUnits[] = $item;
        return $this;
    }
}
