<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for userInfo StructType
 * @subpackage Structs
 */
class UserInfo extends AbstractStructBase
{
    /**
     * The userIdHashCode
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $userIdHashCode;
    /**
     * The accountType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accountType;
    /**
     * The accountStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accountStatus;
    /**
     * The nickname
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * - ref: tns:nickname
     * @var string
     */
    public $nickname;
    /**
     * The profileUrl
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 2048
     * - minOccurs: 0
     * @var string
     */
    public $profileUrl;
    /**
     * The pictureUrl
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 2048
     * - minOccurs: 0
     * @var string
     */
    public $pictureUrl;
    /**
     * Constructor method for userInfo
     * @uses UserInfo::setUserIdHashCode()
     * @uses UserInfo::setAccountType()
     * @uses UserInfo::setAccountStatus()
     * @uses UserInfo::setNickname()
     * @uses UserInfo::setProfileUrl()
     * @uses UserInfo::setPictureUrl()
     * @param string $userIdHashCode
     * @param string $accountType
     * @param string $accountStatus
     * @param string $nickname
     * @param string $profileUrl
     * @param string $pictureUrl
     */
    public function __construct($userIdHashCode = null, $accountType = null, $accountStatus = null, $nickname = null, $profileUrl = null, $pictureUrl = null)
    {
        $this
            ->setUserIdHashCode($userIdHashCode)
            ->setAccountType($accountType)
            ->setAccountStatus($accountStatus)
            ->setNickname($nickname)
            ->setProfileUrl($profileUrl)
            ->setPictureUrl($pictureUrl);
    }
    /**
     * Get userIdHashCode value
     * @return string
     */
    public function getUserIdHashCode()
    {
        return $this->userIdHashCode;
    }
    /**
     * Set userIdHashCode value
     * @param string $userIdHashCode
     * @return \StructType\UserInfo
     */
    public function setUserIdHashCode($userIdHashCode = null)
    {
        // validation for constraint: string
        if (!is_null($userIdHashCode) && !is_string($userIdHashCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userIdHashCode, true), gettype($userIdHashCode)), __LINE__);
        }
        $this->userIdHashCode = $userIdHashCode;
        return $this;
    }
    /**
     * Get accountType value
     * @return string|null
     */
    public function getAccountType()
    {
        return $this->accountType;
    }
    /**
     * Set accountType value
     * @uses \EnumType\UserAccountType::valueIsValid()
     * @uses \EnumType\UserAccountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountType
     * @return \StructType\UserInfo
     */
    public function setAccountType($accountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UserAccountType::valueIsValid($accountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UserAccountType', is_array($accountType) ? implode(', ', $accountType) : var_export($accountType, true), implode(', ', \EnumType\UserAccountType::getValidValues())), __LINE__);
        }
        $this->accountType = $accountType;
        return $this;
    }
    /**
     * Get accountStatus value
     * @return string|null
     */
    public function getAccountStatus()
    {
        return $this->accountStatus;
    }
    /**
     * Set accountStatus value
     * @uses \EnumType\UserAccountStatus::valueIsValid()
     * @uses \EnumType\UserAccountStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountStatus
     * @return \StructType\UserInfo
     */
    public function setAccountStatus($accountStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UserAccountStatus::valueIsValid($accountStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UserAccountStatus', is_array($accountStatus) ? implode(', ', $accountStatus) : var_export($accountStatus, true), implode(', ', \EnumType\UserAccountStatus::getValidValues())), __LINE__);
        }
        $this->accountStatus = $accountStatus;
        return $this;
    }
    /**
     * Get nickname value
     * @return string|null
     */
    public function getNickname()
    {
        return $this->nickname;
    }
    /**
     * Set nickname value
     * @param string $nickname
     * @return \StructType\UserInfo
     */
    public function setNickname($nickname = null)
    {
        // validation for constraint: string
        if (!is_null($nickname) && !is_string($nickname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nickname, true), gettype($nickname)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($nickname) && mb_strlen($nickname) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($nickname)), __LINE__);
        }
        $this->nickname = $nickname;
        return $this;
    }
    /**
     * Get profileUrl value
     * @return string|null
     */
    public function getProfileUrl()
    {
        return $this->profileUrl;
    }
    /**
     * Set profileUrl value
     * @param string $profileUrl
     * @return \StructType\UserInfo
     */
    public function setProfileUrl($profileUrl = null)
    {
        // validation for constraint: string
        if (!is_null($profileUrl) && !is_string($profileUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileUrl, true), gettype($profileUrl)), __LINE__);
        }
        // validation for constraint: maxLength(2048)
        if (!is_null($profileUrl) && mb_strlen($profileUrl) > 2048) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2048', mb_strlen($profileUrl)), __LINE__);
        }
        $this->profileUrl = $profileUrl;
        return $this;
    }
    /**
     * Get pictureUrl value
     * @return string|null
     */
    public function getPictureUrl()
    {
        return $this->pictureUrl;
    }
    /**
     * Set pictureUrl value
     * @param string $pictureUrl
     * @return \StructType\UserInfo
     */
    public function setPictureUrl($pictureUrl = null)
    {
        // validation for constraint: string
        if (!is_null($pictureUrl) && !is_string($pictureUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pictureUrl, true), gettype($pictureUrl)), __LINE__);
        }
        // validation for constraint: maxLength(2048)
        if (!is_null($pictureUrl) && mb_strlen($pictureUrl) > 2048) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2048', mb_strlen($pictureUrl)), __LINE__);
        }
        $this->pictureUrl = $pictureUrl;
        return $this;
    }
}
