<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tagsData StructType
 * @subpackage Structs
 */
class TagsData extends AbstractStructBase
{
    /**
     * The explicit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $explicit;
    /**
     * The premium
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $premium;
    /**
     * Constructor method for tagsData
     * @uses TagsData::setExplicit()
     * @uses TagsData::setPremium()
     * @param int $explicit
     * @param int $premium
     */
    public function __construct($explicit = null, $premium = null)
    {
        $this
            ->setExplicit($explicit)
            ->setPremium($premium);
    }
    /**
     * Get explicit value
     * @return int|null
     */
    public function getExplicit()
    {
        return $this->explicit;
    }
    /**
     * Set explicit value
     * @param int $explicit
     * @return \StructType\TagsData
     */
    public function setExplicit($explicit = null)
    {
        // validation for constraint: int
        if (!is_null($explicit) && !(is_int($explicit) || ctype_digit($explicit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($explicit, true), gettype($explicit)), __LINE__);
        }
        $this->explicit = $explicit;
        return $this;
    }
    /**
     * Get premium value
     * @return int|null
     */
    public function getPremium()
    {
        return $this->premium;
    }
    /**
     * Set premium value
     * @param int $premium
     * @return \StructType\TagsData
     */
    public function setPremium($premium = null)
    {
        // validation for constraint: int
        if (!is_null($premium) && !(is_int($premium) || ctype_digit($premium))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($premium, true), gettype($premium)), __LINE__);
        }
        $this->premium = $premium;
        return $this;
    }
}
