<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for setPlayedSeconds StructType
 * @subpackage Structs
 */
class SetPlayedSeconds extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - type: tns:id
     * @var string
     */
    public $id;
    /**
     * The seconds
     * @var int
     */
    public $seconds;
    /**
     * The contextId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contextId;
    /**
     * The privateData
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 2048
     * - minOccurs: 0
     * @var string
     */
    public $privateData;
    /**
     * The offsetMillis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $offsetMillis;
    /**
     * Constructor method for setPlayedSeconds
     * @uses SetPlayedSeconds::setId()
     * @uses SetPlayedSeconds::setSeconds()
     * @uses SetPlayedSeconds::setContextId()
     * @uses SetPlayedSeconds::setPrivateData()
     * @uses SetPlayedSeconds::setOffsetMillis()
     * @param string $id
     * @param int $seconds
     * @param string $contextId
     * @param string $privateData
     * @param int $offsetMillis
     */
    public function __construct($id = null, $seconds = null, $contextId = null, $privateData = null, $offsetMillis = null)
    {
        $this
            ->setId($id)
            ->setSeconds($seconds)
            ->setContextId($contextId)
            ->setPrivateData($privateData)
            ->setOffsetMillis($offsetMillis);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\SetPlayedSeconds
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($id) && mb_strlen($id) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get seconds value
     * @return int|null
     */
    public function getSeconds()
    {
        return $this->seconds;
    }
    /**
     * Set seconds value
     * @param int $seconds
     * @return \StructType\SetPlayedSeconds
     */
    public function setSeconds($seconds = null)
    {
        // validation for constraint: int
        if (!is_null($seconds) && !(is_int($seconds) || ctype_digit($seconds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seconds, true), gettype($seconds)), __LINE__);
        }
        $this->seconds = $seconds;
        return $this;
    }
    /**
     * Get contextId value
     * @return string|null
     */
    public function getContextId()
    {
        return $this->contextId;
    }
    /**
     * Set contextId value
     * @param string $contextId
     * @return \StructType\SetPlayedSeconds
     */
    public function setContextId($contextId = null)
    {
        // validation for constraint: string
        if (!is_null($contextId) && !is_string($contextId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextId, true), gettype($contextId)), __LINE__);
        }
        $this->contextId = $contextId;
        return $this;
    }
    /**
     * Get privateData value
     * @return string|null
     */
    public function getPrivateData()
    {
        return $this->privateData;
    }
    /**
     * Set privateData value
     * @param string $privateData
     * @return \StructType\SetPlayedSeconds
     */
    public function setPrivateData($privateData = null)
    {
        // validation for constraint: string
        if (!is_null($privateData) && !is_string($privateData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($privateData, true), gettype($privateData)), __LINE__);
        }
        // validation for constraint: maxLength(2048)
        if (!is_null($privateData) && mb_strlen($privateData) > 2048) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2048', mb_strlen($privateData)), __LINE__);
        }
        $this->privateData = $privateData;
        return $this;
    }
    /**
     * Get offsetMillis value
     * @return int|null
     */
    public function getOffsetMillis()
    {
        return $this->offsetMillis;
    }
    /**
     * Set offsetMillis value
     * @param int $offsetMillis
     * @return \StructType\SetPlayedSeconds
     */
    public function setOffsetMillis($offsetMillis = null)
    {
        // validation for constraint: int
        if (!is_null($offsetMillis) && !(is_int($offsetMillis) || ctype_digit($offsetMillis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($offsetMillis, true), gettype($offsetMillis)), __LINE__);
        }
        $this->offsetMillis = $offsetMillis;
        return $this;
    }
}
