<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for reportPlayStatus StructType
 * @subpackage Structs
 */
class ReportPlayStatus extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - type: tns:id
     * @var string
     */
    public $id;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The contextId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contextId;
    /**
     * The offsetMillis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $offsetMillis;
    /**
     * Constructor method for reportPlayStatus
     * @uses ReportPlayStatus::setId()
     * @uses ReportPlayStatus::setStatus()
     * @uses ReportPlayStatus::setContextId()
     * @uses ReportPlayStatus::setOffsetMillis()
     * @param string $id
     * @param string $status
     * @param string $contextId
     * @param int $offsetMillis
     */
    public function __construct($id = null, $status = null, $contextId = null, $offsetMillis = null)
    {
        $this
            ->setId($id)
            ->setStatus($status)
            ->setContextId($contextId)
            ->setOffsetMillis($offsetMillis);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\ReportPlayStatus
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($id) && mb_strlen($id) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\ReportPlayStatus
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get contextId value
     * @return string|null
     */
    public function getContextId()
    {
        return $this->contextId;
    }
    /**
     * Set contextId value
     * @param string $contextId
     * @return \StructType\ReportPlayStatus
     */
    public function setContextId($contextId = null)
    {
        // validation for constraint: string
        if (!is_null($contextId) && !is_string($contextId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextId, true), gettype($contextId)), __LINE__);
        }
        $this->contextId = $contextId;
        return $this;
    }
    /**
     * Get offsetMillis value
     * @return int|null
     */
    public function getOffsetMillis()
    {
        return $this->offsetMillis;
    }
    /**
     * Set offsetMillis value
     * @param int $offsetMillis
     * @return \StructType\ReportPlayStatus
     */
    public function setOffsetMillis($offsetMillis = null)
    {
        // validation for constraint: int
        if (!is_null($offsetMillis) && !(is_int($offsetMillis) || ctype_digit($offsetMillis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($offsetMillis, true), gettype($offsetMillis)), __LINE__);
        }
        $this->offsetMillis = $offsetMillis;
        return $this;
    }
}
