<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for reorderContainer StructType
 * @subpackage Structs
 */
class ReorderContainer extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - type: tns:id
     * @var string
     */
    public $id;
    /**
     * The from
     * @var string
     */
    public $from;
    /**
     * The to
     * @var int
     */
    public $to;
    /**
     * The updateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - type: tns:id
     * @var string
     */
    public $updateId;
    /**
     * Constructor method for reorderContainer
     * @uses ReorderContainer::setId()
     * @uses ReorderContainer::setFrom()
     * @uses ReorderContainer::setTo()
     * @uses ReorderContainer::setUpdateId()
     * @param string $id
     * @param string $from
     * @param int $to
     * @param string $updateId
     */
    public function __construct($id = null, $from = null, $to = null, $updateId = null)
    {
        $this
            ->setId($id)
            ->setFrom($from)
            ->setTo($to)
            ->setUpdateId($updateId);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\ReorderContainer
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($id) && mb_strlen($id) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get from value
     * @return string|null
     */
    public function getFrom()
    {
        return $this->from;
    }
    /**
     * Set from value
     * @param string $from
     * @return \StructType\ReorderContainer
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        $this->from = $from;
        return $this;
    }
    /**
     * Get to value
     * @return int|null
     */
    public function getTo()
    {
        return $this->to;
    }
    /**
     * Set to value
     * @param int $to
     * @return \StructType\ReorderContainer
     */
    public function setTo($to = null)
    {
        // validation for constraint: int
        if (!is_null($to) && !(is_int($to) || ctype_digit($to))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($to, true), gettype($to)), __LINE__);
        }
        $this->to = $to;
        return $this;
    }
    /**
     * Get updateId value
     * @return string|null
     */
    public function getUpdateId()
    {
        return $this->updateId;
    }
    /**
     * Set updateId value
     * @param string $updateId
     * @return \StructType\ReorderContainer
     */
    public function setUpdateId($updateId = null)
    {
        // validation for constraint: string
        if (!is_null($updateId) && !is_string($updateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateId, true), gettype($updateId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($updateId) && mb_strlen($updateId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($updateId)), __LINE__);
        }
        $this->updateId = $updateId;
        return $this;
    }
}
