<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for removeFromContainer StructType
 * @subpackage Structs
 */
class RemoveFromContainer extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - type: tns:id
     * @var string
     */
    public $id;
    /**
     * The indices
     * @var string
     */
    public $indices;
    /**
     * The updateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - type: tns:id
     * @var string
     */
    public $updateId;
    /**
     * Constructor method for removeFromContainer
     * @uses RemoveFromContainer::setId()
     * @uses RemoveFromContainer::setIndices()
     * @uses RemoveFromContainer::setUpdateId()
     * @param string $id
     * @param string $indices
     * @param string $updateId
     */
    public function __construct($id = null, $indices = null, $updateId = null)
    {
        $this
            ->setId($id)
            ->setIndices($indices)
            ->setUpdateId($updateId);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\RemoveFromContainer
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($id) && mb_strlen($id) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get indices value
     * @return string|null
     */
    public function getIndices()
    {
        return $this->indices;
    }
    /**
     * Set indices value
     * @param string $indices
     * @return \StructType\RemoveFromContainer
     */
    public function setIndices($indices = null)
    {
        // validation for constraint: string
        if (!is_null($indices) && !is_string($indices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indices, true), gettype($indices)), __LINE__);
        }
        $this->indices = $indices;
        return $this;
    }
    /**
     * Get updateId value
     * @return string|null
     */
    public function getUpdateId()
    {
        return $this->updateId;
    }
    /**
     * Set updateId value
     * @param string $updateId
     * @return \StructType\RemoveFromContainer
     */
    public function setUpdateId($updateId = null)
    {
        // validation for constraint: string
        if (!is_null($updateId) && !is_string($updateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateId, true), gettype($updateId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($updateId) && mb_strlen($updateId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($updateId)), __LINE__);
        }
        $this->updateId = $updateId;
        return $this;
    }
}
