<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for relatedActions StructType
 * @subpackage Structs
 */
class RelatedActions extends AbstractStructBase
{
    /**
     * The action
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GenericAction[]
     */
    public $action;
    /**
     * Constructor method for relatedActions
     * @uses RelatedActions::setAction()
     * @param \StructType\GenericAction[] $action
     */
    public function __construct(array $action = array())
    {
        $this
            ->setAction($action);
    }
    /**
     * Get action value
     * @return \StructType\GenericAction[]|null
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * This method is responsible for validating the values passed to the setAction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActionForArrayConstraintsFromSetAction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $relatedActionsActionItem) {
            // validation for constraint: itemType
            if (!$relatedActionsActionItem instanceof \StructType\GenericAction) {
                $invalidValues[] = is_object($relatedActionsActionItem) ? get_class($relatedActionsActionItem) : sprintf('%s(%s)', gettype($relatedActionsActionItem), var_export($relatedActionsActionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The action property can only contain items of type \StructType\GenericAction, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set action value
     * @throws \InvalidArgumentException
     * @param \StructType\GenericAction[] $action
     * @return \StructType\RelatedActions
     */
    public function setAction(array $action = array())
    {
        // validation for constraint: array
        if ('' !== ($actionArrayErrorMessage = self::validateActionForArrayConstraintsFromSetAction($action))) {
            throw new \InvalidArgumentException($actionArrayErrorMessage, __LINE__);
        }
        $this->action = $action;
        return $this;
    }
    /**
     * Add item to action value
     * @throws \InvalidArgumentException
     * @param \StructType\GenericAction $item
     * @return \StructType\RelatedActions
     */
    public function addToAction(\StructType\GenericAction $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GenericAction) {
            throw new \InvalidArgumentException(sprintf('The action property can only contain items of type \StructType\GenericAction, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->action[] = $item;
        return $this;
    }
}
