<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for rateItem StructType
 * @subpackage Structs
 */
class RateItem extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - ref: tns:id
     * - type: tns:id
     * @var string
     */
    public $id;
    /**
     * The rating
     * @var int
     */
    public $rating;
    /**
     * Constructor method for rateItem
     * @uses RateItem::setId()
     * @uses RateItem::setRating()
     * @param string $id
     * @param int $rating
     */
    public function __construct($id = null, $rating = null)
    {
        $this
            ->setId($id)
            ->setRating($rating);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\RateItem
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($id) && mb_strlen($id) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get rating value
     * @return int|null
     */
    public function getRating()
    {
        return $this->rating;
    }
    /**
     * Set rating value
     * @param int $rating
     * @return \StructType\RateItem
     */
    public function setRating($rating = null)
    {
        // validation for constraint: int
        if (!is_null($rating) && !(is_int($rating) || ctype_digit($rating))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rating, true), gettype($rating)), __LINE__);
        }
        $this->rating = $rating;
        return $this;
    }
}
