<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for radioTrackList StructType
 * @subpackage Structs
 */
class RadioTrackList extends AbstractStructBase
{
    /**
     * The count
     * @var int
     */
    public $count;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The mediaMetadata
     * Meta information extracted from the WSDL
     * - choice: mediaMetadata
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * @var \StructType\MediaMetadata
     */
    public $mediaMetadata;
    /**
     * Constructor method for radioTrackList
     * @uses RadioTrackList::setCount()
     * @uses RadioTrackList::setId()
     * @uses RadioTrackList::setName()
     * @uses RadioTrackList::setMediaMetadata()
     * @param int $count
     * @param string $id
     * @param string $name
     * @param \StructType\MediaMetadata $mediaMetadata
     */
    public function __construct($count = null, $id = null, $name = null, \StructType\MediaMetadata $mediaMetadata = null)
    {
        $this
            ->setCount($count)
            ->setId($id)
            ->setName($name)
            ->setMediaMetadata($mediaMetadata);
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\RadioTrackList
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\RadioTrackList
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RadioTrackList
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get mediaMetadata value
     * @return \StructType\MediaMetadata|null
     */
    public function getMediaMetadata()
    {
        return isset($this->mediaMetadata) ? $this->mediaMetadata : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMediaMetadata method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMediaMetadata method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMediaMetadataForChoiceConstraintsFromSetMediaMetadata($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property mediaMetadata can\'t be set as the property %s is already set. Only one property must be set among these properties: mediaMetadata, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set mediaMetadata value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MediaMetadata $mediaMetadata
     * @return \StructType\RadioTrackList
     */
    public function setMediaMetadata(\StructType\MediaMetadata $mediaMetadata = null)
    {
        // validation for constraint: choice(mediaMetadata)
        if ('' !== ($mediaMetadataChoiceErrorMessage = self::validateMediaMetadataForChoiceConstraintsFromSetMediaMetadata($mediaMetadata))) {
            throw new \InvalidArgumentException($mediaMetadataChoiceErrorMessage, __LINE__);
        }
        if (is_null($mediaMetadata) || (is_array($mediaMetadata) && empty($mediaMetadata))) {
            unset($this->mediaMetadata);
        } else {
            $this->mediaMetadata = $mediaMetadata;
        }
        return $this;
    }
}
