<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for positionInformation StructType
 * @subpackage Structs
 */
class PositionInformation extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - ref: tns:id
     * - type: tns:id
     * @var string
     */
    public $id;
    /**
     * The index
     * @var int
     */
    public $index;
    /**
     * The offsetMillis
     * @var int
     */
    public $offsetMillis;
    /**
     * The isCompleted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isCompleted;
    /**
     * Constructor method for positionInformation
     * @uses PositionInformation::setId()
     * @uses PositionInformation::setIndex()
     * @uses PositionInformation::setOffsetMillis()
     * @uses PositionInformation::setIsCompleted()
     * @param string $id
     * @param int $index
     * @param int $offsetMillis
     * @param bool $isCompleted
     */
    public function __construct($id = null, $index = null, $offsetMillis = null, $isCompleted = null)
    {
        $this
            ->setId($id)
            ->setIndex($index)
            ->setOffsetMillis($offsetMillis)
            ->setIsCompleted($isCompleted);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\PositionInformation
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($id) && mb_strlen($id) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get index value
     * @return int|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @param int $index
     * @return \StructType\PositionInformation
     */
    public function setIndex($index = null)
    {
        // validation for constraint: int
        if (!is_null($index) && !(is_int($index) || ctype_digit($index))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($index, true), gettype($index)), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get offsetMillis value
     * @return int|null
     */
    public function getOffsetMillis()
    {
        return $this->offsetMillis;
    }
    /**
     * Set offsetMillis value
     * @param int $offsetMillis
     * @return \StructType\PositionInformation
     */
    public function setOffsetMillis($offsetMillis = null)
    {
        // validation for constraint: int
        if (!is_null($offsetMillis) && !(is_int($offsetMillis) || ctype_digit($offsetMillis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($offsetMillis, true), gettype($offsetMillis)), __LINE__);
        }
        $this->offsetMillis = $offsetMillis;
        return $this;
    }
    /**
     * Get isCompleted value
     * @return bool|null
     */
    public function getIsCompleted()
    {
        return $this->isCompleted;
    }
    /**
     * Set isCompleted value
     * @param bool $isCompleted
     * @return \StructType\PositionInformation
     */
    public function setIsCompleted($isCompleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCompleted) && !is_bool($isCompleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCompleted, true), gettype($isCompleted)), __LINE__);
        }
        $this->isCompleted = $isCompleted;
        return $this;
    }
}
