<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mediaMetadata StructType
 * @subpackage Structs
 */
class MediaMetadata extends AbstractMedia
{
    /**
     * The mimeType
     * @var string
     */
    public $mimeType;
    /**
     * The trackMetadata
     * Meta information extracted from the WSDL
     * - choice: trackMetadata | streamMetadata
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\TrackMetadata
     */
    public $trackMetadata;
    /**
     * The streamMetadata
     * Meta information extracted from the WSDL
     * - choice: trackMetadata | streamMetadata
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\StreamMetadata
     */
    public $streamMetadata;
    /**
     * The dynamic
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DynamicData
     */
    public $dynamic;
    /**
     * The behaviors
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BehaviorsData
     */
    public $behaviors;
    /**
     * Constructor method for mediaMetadata
     * @uses MediaMetadata::setMimeType()
     * @uses MediaMetadata::setTrackMetadata()
     * @uses MediaMetadata::setStreamMetadata()
     * @uses MediaMetadata::setDynamic()
     * @uses MediaMetadata::setBehaviors()
     * @param string $mimeType
     * @param \StructType\TrackMetadata $trackMetadata
     * @param \StructType\StreamMetadata $streamMetadata
     * @param \StructType\DynamicData $dynamic
     * @param \StructType\BehaviorsData $behaviors
     */
    public function __construct($mimeType = null, \StructType\TrackMetadata $trackMetadata = null, \StructType\StreamMetadata $streamMetadata = null, \StructType\DynamicData $dynamic = null, \StructType\BehaviorsData $behaviors = null)
    {
        $this
            ->setMimeType($mimeType)
            ->setTrackMetadata($trackMetadata)
            ->setStreamMetadata($streamMetadata)
            ->setDynamic($dynamic)
            ->setBehaviors($behaviors);
    }
    /**
     * Get mimeType value
     * @return string|null
     */
    public function getMimeType()
    {
        return $this->mimeType;
    }
    /**
     * Set mimeType value
     * @param string $mimeType
     * @return \StructType\MediaMetadata
     */
    public function setMimeType($mimeType = null)
    {
        // validation for constraint: string
        if (!is_null($mimeType) && !is_string($mimeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mimeType, true), gettype($mimeType)), __LINE__);
        }
        $this->mimeType = $mimeType;
        return $this;
    }
    /**
     * Get trackMetadata value
     * @return \StructType\TrackMetadata|null
     */
    public function getTrackMetadata()
    {
        return isset($this->trackMetadata) ? $this->trackMetadata : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTrackMetadata method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrackMetadata method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTrackMetadataForChoiceConstraintsFromSetTrackMetadata($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'streamMetadata',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property trackMetadata can\'t be set as the property %s is already set. Only one property must be set among these properties: trackMetadata, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set trackMetadata value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TrackMetadata $trackMetadata
     * @return \StructType\MediaMetadata
     */
    public function setTrackMetadata(\StructType\TrackMetadata $trackMetadata = null)
    {
        // validation for constraint: choice(trackMetadata, streamMetadata)
        if ('' !== ($trackMetadataChoiceErrorMessage = self::validateTrackMetadataForChoiceConstraintsFromSetTrackMetadata($trackMetadata))) {
            throw new \InvalidArgumentException($trackMetadataChoiceErrorMessage, __LINE__);
        }
        if (is_null($trackMetadata) || (is_array($trackMetadata) && empty($trackMetadata))) {
            unset($this->trackMetadata);
        } else {
            $this->trackMetadata = $trackMetadata;
        }
        return $this;
    }
    /**
     * Get streamMetadata value
     * @return \StructType\StreamMetadata|null
     */
    public function getStreamMetadata()
    {
        return isset($this->streamMetadata) ? $this->streamMetadata : null;
    }
    /**
     * This method is responsible for validating the value passed to the setStreamMetadata method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStreamMetadata method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateStreamMetadataForChoiceConstraintsFromSetStreamMetadata($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'trackMetadata',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property streamMetadata can\'t be set as the property %s is already set. Only one property must be set among these properties: streamMetadata, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set streamMetadata value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\StreamMetadata $streamMetadata
     * @return \StructType\MediaMetadata
     */
    public function setStreamMetadata(\StructType\StreamMetadata $streamMetadata = null)
    {
        // validation for constraint: choice(trackMetadata, streamMetadata)
        if ('' !== ($streamMetadataChoiceErrorMessage = self::validateStreamMetadataForChoiceConstraintsFromSetStreamMetadata($streamMetadata))) {
            throw new \InvalidArgumentException($streamMetadataChoiceErrorMessage, __LINE__);
        }
        if (is_null($streamMetadata) || (is_array($streamMetadata) && empty($streamMetadata))) {
            unset($this->streamMetadata);
        } else {
            $this->streamMetadata = $streamMetadata;
        }
        return $this;
    }
    /**
     * Get dynamic value
     * @return \StructType\DynamicData|null
     */
    public function getDynamic()
    {
        return $this->dynamic;
    }
    /**
     * Set dynamic value
     * @param \StructType\DynamicData $dynamic
     * @return \StructType\MediaMetadata
     */
    public function setDynamic(\StructType\DynamicData $dynamic = null)
    {
        $this->dynamic = $dynamic;
        return $this;
    }
    /**
     * Get behaviors value
     * @return \StructType\BehaviorsData|null
     */
    public function getBehaviors()
    {
        return $this->behaviors;
    }
    /**
     * Set behaviors value
     * @param \StructType\BehaviorsData $behaviors
     * @return \StructType\MediaMetadata
     */
    public function setBehaviors(\StructType\BehaviorsData $behaviors = null)
    {
        $this->behaviors = $behaviors;
        return $this;
    }
}
