<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for lastUpdate StructType
 * @subpackage Structs
 */
class LastUpdate extends AbstractStructBase
{
    /**
     * The catalog
     * @var string
     */
    public $catalog;
    /**
     * The favorites
     * @var string
     */
    public $favorites;
    /**
     * The pollInterval
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $pollInterval;
    /**
     * The autoRefreshEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $autoRefreshEnabled;
    /**
     * Constructor method for lastUpdate
     * @uses LastUpdate::setCatalog()
     * @uses LastUpdate::setFavorites()
     * @uses LastUpdate::setPollInterval()
     * @uses LastUpdate::setAutoRefreshEnabled()
     * @param string $catalog
     * @param string $favorites
     * @param int $pollInterval
     * @param bool $autoRefreshEnabled
     */
    public function __construct($catalog = null, $favorites = null, $pollInterval = null, $autoRefreshEnabled = null)
    {
        $this
            ->setCatalog($catalog)
            ->setFavorites($favorites)
            ->setPollInterval($pollInterval)
            ->setAutoRefreshEnabled($autoRefreshEnabled);
    }
    /**
     * Get catalog value
     * @return string|null
     */
    public function getCatalog()
    {
        return $this->catalog;
    }
    /**
     * Set catalog value
     * @param string $catalog
     * @return \StructType\LastUpdate
     */
    public function setCatalog($catalog = null)
    {
        // validation for constraint: string
        if (!is_null($catalog) && !is_string($catalog)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($catalog, true), gettype($catalog)), __LINE__);
        }
        $this->catalog = $catalog;
        return $this;
    }
    /**
     * Get favorites value
     * @return string|null
     */
    public function getFavorites()
    {
        return $this->favorites;
    }
    /**
     * Set favorites value
     * @param string $favorites
     * @return \StructType\LastUpdate
     */
    public function setFavorites($favorites = null)
    {
        // validation for constraint: string
        if (!is_null($favorites) && !is_string($favorites)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($favorites, true), gettype($favorites)), __LINE__);
        }
        $this->favorites = $favorites;
        return $this;
    }
    /**
     * Get pollInterval value
     * @return int|null
     */
    public function getPollInterval()
    {
        return $this->pollInterval;
    }
    /**
     * Set pollInterval value
     * @param int $pollInterval
     * @return \StructType\LastUpdate
     */
    public function setPollInterval($pollInterval = null)
    {
        // validation for constraint: int
        if (!is_null($pollInterval) && !(is_int($pollInterval) || ctype_digit($pollInterval))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pollInterval, true), gettype($pollInterval)), __LINE__);
        }
        $this->pollInterval = $pollInterval;
        return $this;
    }
    /**
     * Get autoRefreshEnabled value
     * @return bool|null
     */
    public function getAutoRefreshEnabled()
    {
        return $this->autoRefreshEnabled;
    }
    /**
     * Set autoRefreshEnabled value
     * @param bool $autoRefreshEnabled
     * @return \StructType\LastUpdate
     */
    public function setAutoRefreshEnabled($autoRefreshEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoRefreshEnabled) && !is_bool($autoRefreshEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoRefreshEnabled, true), gettype($autoRefreshEnabled)), __LINE__);
        }
        $this->autoRefreshEnabled = $autoRefreshEnabled;
        return $this;
    }
}
