<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getSessionId StructType
 * @subpackage Structs
 */
class GetSessionId extends AbstractStructBase
{
    /**
     * The username
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - ref: tns:username
     * @var string
     */
    public $username;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - ref: tns:password
     * @var string
     */
    public $password;
    /**
     * Constructor method for getSessionId
     * @uses GetSessionId::setUsername()
     * @uses GetSessionId::setPassword()
     * @param string $username
     * @param string $password
     */
    public function __construct($username = null, $password = null)
    {
        $this
            ->setUsername($username)
            ->setPassword($password);
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \StructType\GetSessionId
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($username) && mb_strlen($username) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GetSessionId
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($password) && mb_strlen($password) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
}
