<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getExtendedMetadataText StructType
 * @subpackage Structs
 */
class GetExtendedMetadataText extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - ref: tns:id
     * - type: tns:id
     * @var string
     */
    public $id;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * Constructor method for getExtendedMetadataText
     * @uses GetExtendedMetadataText::setId()
     * @uses GetExtendedMetadataText::setType()
     * @param string $id
     * @param string $type
     */
    public function __construct($id = null, $type = null)
    {
        $this
            ->setId($id)
            ->setType($type);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\GetExtendedMetadataText
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($id) && mb_strlen($id) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\GetExtendedMetadataText
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
}
