<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getDeviceAuthToken StructType
 * @subpackage Structs
 */
class GetDeviceAuthToken extends AbstractStructBase
{
    /**
     * The householdId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - type: tns:id
     * @var string
     */
    public $householdId;
    /**
     * The linkCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $linkCode;
    /**
     * The linkDeviceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $linkDeviceId;
    /**
     * The callbackPath
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $callbackPath;
    /**
     * Constructor method for getDeviceAuthToken
     * @uses GetDeviceAuthToken::setHouseholdId()
     * @uses GetDeviceAuthToken::setLinkCode()
     * @uses GetDeviceAuthToken::setLinkDeviceId()
     * @uses GetDeviceAuthToken::setCallbackPath()
     * @param string $householdId
     * @param string $linkCode
     * @param string $linkDeviceId
     * @param string $callbackPath
     */
    public function __construct($householdId = null, $linkCode = null, $linkDeviceId = null, $callbackPath = null)
    {
        $this
            ->setHouseholdId($householdId)
            ->setLinkCode($linkCode)
            ->setLinkDeviceId($linkDeviceId)
            ->setCallbackPath($callbackPath);
    }
    /**
     * Get householdId value
     * @return string|null
     */
    public function getHouseholdId()
    {
        return $this->householdId;
    }
    /**
     * Set householdId value
     * @param string $householdId
     * @return \StructType\GetDeviceAuthToken
     */
    public function setHouseholdId($householdId = null)
    {
        // validation for constraint: string
        if (!is_null($householdId) && !is_string($householdId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($householdId, true), gettype($householdId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($householdId) && mb_strlen($householdId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($householdId)), __LINE__);
        }
        $this->householdId = $householdId;
        return $this;
    }
    /**
     * Get linkCode value
     * @return string|null
     */
    public function getLinkCode()
    {
        return $this->linkCode;
    }
    /**
     * Set linkCode value
     * @param string $linkCode
     * @return \StructType\GetDeviceAuthToken
     */
    public function setLinkCode($linkCode = null)
    {
        // validation for constraint: string
        if (!is_null($linkCode) && !is_string($linkCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkCode, true), gettype($linkCode)), __LINE__);
        }
        $this->linkCode = $linkCode;
        return $this;
    }
    /**
     * Get linkDeviceId value
     * @return string|null
     */
    public function getLinkDeviceId()
    {
        return $this->linkDeviceId;
    }
    /**
     * Set linkDeviceId value
     * @param string $linkDeviceId
     * @return \StructType\GetDeviceAuthToken
     */
    public function setLinkDeviceId($linkDeviceId = null)
    {
        // validation for constraint: string
        if (!is_null($linkDeviceId) && !is_string($linkDeviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkDeviceId, true), gettype($linkDeviceId)), __LINE__);
        }
        $this->linkDeviceId = $linkDeviceId;
        return $this;
    }
    /**
     * Get callbackPath value
     * @return string|null
     */
    public function getCallbackPath()
    {
        return $this->callbackPath;
    }
    /**
     * Set callbackPath value
     * @param string $callbackPath
     * @return \StructType\GetDeviceAuthToken
     */
    public function setCallbackPath($callbackPath = null)
    {
        // validation for constraint: string
        if (!is_null($callbackPath) && !is_string($callbackPath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callbackPath, true), gettype($callbackPath)), __LINE__);
        }
        $this->callbackPath = $callbackPath;
        return $this;
    }
}
