<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getAppLink StructType
 * @subpackage Structs
 */
class GetAppLink extends AbstractStructBase
{
    /**
     * The householdId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - type: tns:id
     * @var string
     */
    public $householdId;
    /**
     * The hardware
     * @var string
     */
    public $hardware;
    /**
     * The osVersion
     * @var string
     */
    public $osVersion;
    /**
     * The sonosAppName
     * @var string
     */
    public $sonosAppName;
    /**
     * The callbackPath
     * @var string
     */
    public $callbackPath;
    /**
     * Constructor method for getAppLink
     * @uses GetAppLink::setHouseholdId()
     * @uses GetAppLink::setHardware()
     * @uses GetAppLink::setOsVersion()
     * @uses GetAppLink::setSonosAppName()
     * @uses GetAppLink::setCallbackPath()
     * @param string $householdId
     * @param string $hardware
     * @param string $osVersion
     * @param string $sonosAppName
     * @param string $callbackPath
     */
    public function __construct($householdId = null, $hardware = null, $osVersion = null, $sonosAppName = null, $callbackPath = null)
    {
        $this
            ->setHouseholdId($householdId)
            ->setHardware($hardware)
            ->setOsVersion($osVersion)
            ->setSonosAppName($sonosAppName)
            ->setCallbackPath($callbackPath);
    }
    /**
     * Get householdId value
     * @return string|null
     */
    public function getHouseholdId()
    {
        return $this->householdId;
    }
    /**
     * Set householdId value
     * @param string $householdId
     * @return \StructType\GetAppLink
     */
    public function setHouseholdId($householdId = null)
    {
        // validation for constraint: string
        if (!is_null($householdId) && !is_string($householdId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($householdId, true), gettype($householdId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($householdId) && mb_strlen($householdId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($householdId)), __LINE__);
        }
        $this->householdId = $householdId;
        return $this;
    }
    /**
     * Get hardware value
     * @return string|null
     */
    public function getHardware()
    {
        return $this->hardware;
    }
    /**
     * Set hardware value
     * @param string $hardware
     * @return \StructType\GetAppLink
     */
    public function setHardware($hardware = null)
    {
        // validation for constraint: string
        if (!is_null($hardware) && !is_string($hardware)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hardware, true), gettype($hardware)), __LINE__);
        }
        $this->hardware = $hardware;
        return $this;
    }
    /**
     * Get osVersion value
     * @return string|null
     */
    public function getOsVersion()
    {
        return $this->osVersion;
    }
    /**
     * Set osVersion value
     * @param string $osVersion
     * @return \StructType\GetAppLink
     */
    public function setOsVersion($osVersion = null)
    {
        // validation for constraint: string
        if (!is_null($osVersion) && !is_string($osVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($osVersion, true), gettype($osVersion)), __LINE__);
        }
        $this->osVersion = $osVersion;
        return $this;
    }
    /**
     * Get sonosAppName value
     * @return string|null
     */
    public function getSonosAppName()
    {
        return $this->sonosAppName;
    }
    /**
     * Set sonosAppName value
     * @param string $sonosAppName
     * @return \StructType\GetAppLink
     */
    public function setSonosAppName($sonosAppName = null)
    {
        // validation for constraint: string
        if (!is_null($sonosAppName) && !is_string($sonosAppName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonosAppName, true), gettype($sonosAppName)), __LINE__);
        }
        $this->sonosAppName = $sonosAppName;
        return $this;
    }
    /**
     * Get callbackPath value
     * @return string|null
     */
    public function getCallbackPath()
    {
        return $this->callbackPath;
    }
    /**
     * Set callbackPath value
     * @param string $callbackPath
     * @return \StructType\GetAppLink
     */
    public function setCallbackPath($callbackPath = null)
    {
        // validation for constraint: string
        if (!is_null($callbackPath) && !is_string($callbackPath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callbackPath, true), gettype($callbackPath)), __LINE__);
        }
        $this->callbackPath = $callbackPath;
        return $this;
    }
}
