<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for genericAction StructType
 * @subpackage Structs
 */
class GenericAction extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - ref: tns:id
     * - type: tns:id
     * @var string
     */
    public $id;
    /**
     * The title
     * @var string
     */
    public $title;
    /**
     * The actionType
     * @var string
     */
    public $actionType;
    /**
     * The showInBrowse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $showInBrowse;
    /**
     * The openUrlAction
     * Meta information extracted from the WSDL
     * - choice: openUrlAction | simpleHttpRequestAction | rateItemAction
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\OpenUrlAction
     */
    public $openUrlAction;
    /**
     * The simpleHttpRequestAction
     * Meta information extracted from the WSDL
     * - choice: openUrlAction | simpleHttpRequestAction | rateItemAction
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\SimpleHttpRequestAction
     */
    public $simpleHttpRequestAction;
    /**
     * The rateItemAction
     * Meta information extracted from the WSDL
     * - choice: openUrlAction | simpleHttpRequestAction | rateItemAction
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\RateItemAction
     */
    public $rateItemAction;
    /**
     * The successMessageStringId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $successMessageStringId;
    /**
     * The failureMessageStringId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $failureMessageStringId;
    /**
     * Constructor method for genericAction
     * @uses GenericAction::setId()
     * @uses GenericAction::setTitle()
     * @uses GenericAction::setActionType()
     * @uses GenericAction::setShowInBrowse()
     * @uses GenericAction::setOpenUrlAction()
     * @uses GenericAction::setSimpleHttpRequestAction()
     * @uses GenericAction::setRateItemAction()
     * @uses GenericAction::setSuccessMessageStringId()
     * @uses GenericAction::setFailureMessageStringId()
     * @param string $id
     * @param string $title
     * @param string $actionType
     * @param bool $showInBrowse
     * @param \StructType\OpenUrlAction $openUrlAction
     * @param \StructType\SimpleHttpRequestAction $simpleHttpRequestAction
     * @param \StructType\RateItemAction $rateItemAction
     * @param string $successMessageStringId
     * @param string $failureMessageStringId
     */
    public function __construct($id = null, $title = null, $actionType = null, $showInBrowse = null, \StructType\OpenUrlAction $openUrlAction = null, \StructType\SimpleHttpRequestAction $simpleHttpRequestAction = null, \StructType\RateItemAction $rateItemAction = null, $successMessageStringId = null, $failureMessageStringId = null)
    {
        $this
            ->setId($id)
            ->setTitle($title)
            ->setActionType($actionType)
            ->setShowInBrowse($showInBrowse)
            ->setOpenUrlAction($openUrlAction)
            ->setSimpleHttpRequestAction($simpleHttpRequestAction)
            ->setRateItemAction($rateItemAction)
            ->setSuccessMessageStringId($successMessageStringId)
            ->setFailureMessageStringId($failureMessageStringId);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\GenericAction
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($id) && mb_strlen($id) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\GenericAction
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get actionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->actionType;
    }
    /**
     * Set actionType value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\GenericAction
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->actionType = $actionType;
        return $this;
    }
    /**
     * Get showInBrowse value
     * @return bool|null
     */
    public function getShowInBrowse()
    {
        return $this->showInBrowse;
    }
    /**
     * Set showInBrowse value
     * @param bool $showInBrowse
     * @return \StructType\GenericAction
     */
    public function setShowInBrowse($showInBrowse = null)
    {
        // validation for constraint: boolean
        if (!is_null($showInBrowse) && !is_bool($showInBrowse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showInBrowse, true), gettype($showInBrowse)), __LINE__);
        }
        $this->showInBrowse = $showInBrowse;
        return $this;
    }
    /**
     * Get openUrlAction value
     * @return \StructType\OpenUrlAction|null
     */
    public function getOpenUrlAction()
    {
        return isset($this->openUrlAction) ? $this->openUrlAction : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOpenUrlAction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOpenUrlAction method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOpenUrlActionForChoiceConstraintsFromSetOpenUrlAction($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'simpleHttpRequestAction',
            'rateItemAction',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property openUrlAction can\'t be set as the property %s is already set. Only one property must be set among these properties: openUrlAction, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set openUrlAction value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OpenUrlAction $openUrlAction
     * @return \StructType\GenericAction
     */
    public function setOpenUrlAction(\StructType\OpenUrlAction $openUrlAction = null)
    {
        // validation for constraint: choice(openUrlAction, simpleHttpRequestAction, rateItemAction)
        if ('' !== ($openUrlActionChoiceErrorMessage = self::validateOpenUrlActionForChoiceConstraintsFromSetOpenUrlAction($openUrlAction))) {
            throw new \InvalidArgumentException($openUrlActionChoiceErrorMessage, __LINE__);
        }
        if (is_null($openUrlAction) || (is_array($openUrlAction) && empty($openUrlAction))) {
            unset($this->openUrlAction);
        } else {
            $this->openUrlAction = $openUrlAction;
        }
        return $this;
    }
    /**
     * Get simpleHttpRequestAction value
     * @return \StructType\SimpleHttpRequestAction|null
     */
    public function getSimpleHttpRequestAction()
    {
        return isset($this->simpleHttpRequestAction) ? $this->simpleHttpRequestAction : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSimpleHttpRequestAction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSimpleHttpRequestAction method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSimpleHttpRequestActionForChoiceConstraintsFromSetSimpleHttpRequestAction($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'openUrlAction',
            'rateItemAction',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property simpleHttpRequestAction can\'t be set as the property %s is already set. Only one property must be set among these properties: simpleHttpRequestAction, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set simpleHttpRequestAction value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SimpleHttpRequestAction $simpleHttpRequestAction
     * @return \StructType\GenericAction
     */
    public function setSimpleHttpRequestAction(\StructType\SimpleHttpRequestAction $simpleHttpRequestAction = null)
    {
        // validation for constraint: choice(openUrlAction, simpleHttpRequestAction, rateItemAction)
        if ('' !== ($simpleHttpRequestActionChoiceErrorMessage = self::validateSimpleHttpRequestActionForChoiceConstraintsFromSetSimpleHttpRequestAction($simpleHttpRequestAction))) {
            throw new \InvalidArgumentException($simpleHttpRequestActionChoiceErrorMessage, __LINE__);
        }
        if (is_null($simpleHttpRequestAction) || (is_array($simpleHttpRequestAction) && empty($simpleHttpRequestAction))) {
            unset($this->simpleHttpRequestAction);
        } else {
            $this->simpleHttpRequestAction = $simpleHttpRequestAction;
        }
        return $this;
    }
    /**
     * Get rateItemAction value
     * @return \StructType\RateItemAction|null
     */
    public function getRateItemAction()
    {
        return isset($this->rateItemAction) ? $this->rateItemAction : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRateItemAction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRateItemAction method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRateItemActionForChoiceConstraintsFromSetRateItemAction($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'openUrlAction',
            'simpleHttpRequestAction',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property rateItemAction can\'t be set as the property %s is already set. Only one property must be set among these properties: rateItemAction, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set rateItemAction value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RateItemAction $rateItemAction
     * @return \StructType\GenericAction
     */
    public function setRateItemAction(\StructType\RateItemAction $rateItemAction = null)
    {
        // validation for constraint: choice(openUrlAction, simpleHttpRequestAction, rateItemAction)
        if ('' !== ($rateItemActionChoiceErrorMessage = self::validateRateItemActionForChoiceConstraintsFromSetRateItemAction($rateItemAction))) {
            throw new \InvalidArgumentException($rateItemActionChoiceErrorMessage, __LINE__);
        }
        if (is_null($rateItemAction) || (is_array($rateItemAction) && empty($rateItemAction))) {
            unset($this->rateItemAction);
        } else {
            $this->rateItemAction = $rateItemAction;
        }
        return $this;
    }
    /**
     * Get successMessageStringId value
     * @return string|null
     */
    public function getSuccessMessageStringId()
    {
        return $this->successMessageStringId;
    }
    /**
     * Set successMessageStringId value
     * @param string $successMessageStringId
     * @return \StructType\GenericAction
     */
    public function setSuccessMessageStringId($successMessageStringId = null)
    {
        // validation for constraint: string
        if (!is_null($successMessageStringId) && !is_string($successMessageStringId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($successMessageStringId, true), gettype($successMessageStringId)), __LINE__);
        }
        $this->successMessageStringId = $successMessageStringId;
        return $this;
    }
    /**
     * Get failureMessageStringId value
     * @return string|null
     */
    public function getFailureMessageStringId()
    {
        return $this->failureMessageStringId;
    }
    /**
     * Set failureMessageStringId value
     * @param string $failureMessageStringId
     * @return \StructType\GenericAction
     */
    public function setFailureMessageStringId($failureMessageStringId = null)
    {
        // validation for constraint: string
        if (!is_null($failureMessageStringId) && !is_string($failureMessageStringId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($failureMessageStringId, true), gettype($failureMessageStringId)), __LINE__);
        }
        $this->failureMessageStringId = $failureMessageStringId;
        return $this;
    }
}
