<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for extendedMetadata StructType
 * @subpackage Structs
 */
class ExtendedMetadata extends AbstractStructBase
{
    /**
     * The mediaCollection
     * Meta information extracted from the WSDL
     * - choice: mediaCollection | mediaMetadata
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * @var \StructType\MediaCollection
     */
    public $mediaCollection;
    /**
     * The mediaMetadata
     * Meta information extracted from the WSDL
     * - choice: mediaCollection | mediaMetadata
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * @var \StructType\MediaMetadata
     */
    public $mediaMetadata;
    /**
     * The relatedBrowse
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RelatedBrowse[]
     */
    public $relatedBrowse;
    /**
     * The relatedText
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RelatedText[]
     */
    public $relatedText;
    /**
     * The relatedPlay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RelatedPlay
     */
    public $relatedPlay;
    /**
     * The relatedActions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RelatedActions
     */
    public $relatedActions;
    /**
     * Constructor method for extendedMetadata
     * @uses ExtendedMetadata::setMediaCollection()
     * @uses ExtendedMetadata::setMediaMetadata()
     * @uses ExtendedMetadata::setRelatedBrowse()
     * @uses ExtendedMetadata::setRelatedText()
     * @uses ExtendedMetadata::setRelatedPlay()
     * @uses ExtendedMetadata::setRelatedActions()
     * @param \StructType\MediaCollection $mediaCollection
     * @param \StructType\MediaMetadata $mediaMetadata
     * @param \StructType\RelatedBrowse[] $relatedBrowse
     * @param \StructType\RelatedText[] $relatedText
     * @param \StructType\RelatedPlay $relatedPlay
     * @param \StructType\RelatedActions $relatedActions
     */
    public function __construct(\StructType\MediaCollection $mediaCollection = null, \StructType\MediaMetadata $mediaMetadata = null, array $relatedBrowse = array(), array $relatedText = array(), \StructType\RelatedPlay $relatedPlay = null, \StructType\RelatedActions $relatedActions = null)
    {
        $this
            ->setMediaCollection($mediaCollection)
            ->setMediaMetadata($mediaMetadata)
            ->setRelatedBrowse($relatedBrowse)
            ->setRelatedText($relatedText)
            ->setRelatedPlay($relatedPlay)
            ->setRelatedActions($relatedActions);
    }
    /**
     * Get mediaCollection value
     * @return \StructType\MediaCollection|null
     */
    public function getMediaCollection()
    {
        return isset($this->mediaCollection) ? $this->mediaCollection : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMediaCollection method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMediaCollection method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMediaCollectionForChoiceConstraintsFromSetMediaCollection($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'mediaMetadata',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property mediaCollection can\'t be set as the property %s is already set. Only one property must be set among these properties: mediaCollection, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set mediaCollection value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MediaCollection $mediaCollection
     * @return \StructType\ExtendedMetadata
     */
    public function setMediaCollection(\StructType\MediaCollection $mediaCollection = null)
    {
        // validation for constraint: choice(mediaCollection, mediaMetadata)
        if ('' !== ($mediaCollectionChoiceErrorMessage = self::validateMediaCollectionForChoiceConstraintsFromSetMediaCollection($mediaCollection))) {
            throw new \InvalidArgumentException($mediaCollectionChoiceErrorMessage, __LINE__);
        }
        if (is_null($mediaCollection) || (is_array($mediaCollection) && empty($mediaCollection))) {
            unset($this->mediaCollection);
        } else {
            $this->mediaCollection = $mediaCollection;
        }
        return $this;
    }
    /**
     * Get mediaMetadata value
     * @return \StructType\MediaMetadata|null
     */
    public function getMediaMetadata()
    {
        return isset($this->mediaMetadata) ? $this->mediaMetadata : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMediaMetadata method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMediaMetadata method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMediaMetadataForChoiceConstraintsFromSetMediaMetadata($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'mediaCollection',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property mediaMetadata can\'t be set as the property %s is already set. Only one property must be set among these properties: mediaMetadata, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set mediaMetadata value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MediaMetadata $mediaMetadata
     * @return \StructType\ExtendedMetadata
     */
    public function setMediaMetadata(\StructType\MediaMetadata $mediaMetadata = null)
    {
        // validation for constraint: choice(mediaCollection, mediaMetadata)
        if ('' !== ($mediaMetadataChoiceErrorMessage = self::validateMediaMetadataForChoiceConstraintsFromSetMediaMetadata($mediaMetadata))) {
            throw new \InvalidArgumentException($mediaMetadataChoiceErrorMessage, __LINE__);
        }
        if (is_null($mediaMetadata) || (is_array($mediaMetadata) && empty($mediaMetadata))) {
            unset($this->mediaMetadata);
        } else {
            $this->mediaMetadata = $mediaMetadata;
        }
        return $this;
    }
    /**
     * Get relatedBrowse value
     * @return \StructType\RelatedBrowse[]|null
     */
    public function getRelatedBrowse()
    {
        return $this->relatedBrowse;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatedBrowse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatedBrowse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatedBrowseForArrayConstraintsFromSetRelatedBrowse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $extendedMetadataRelatedBrowseItem) {
            // validation for constraint: itemType
            if (!$extendedMetadataRelatedBrowseItem instanceof \StructType\RelatedBrowse) {
                $invalidValues[] = is_object($extendedMetadataRelatedBrowseItem) ? get_class($extendedMetadataRelatedBrowseItem) : sprintf('%s(%s)', gettype($extendedMetadataRelatedBrowseItem), var_export($extendedMetadataRelatedBrowseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The relatedBrowse property can only contain items of type \StructType\RelatedBrowse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set relatedBrowse value
     * @throws \InvalidArgumentException
     * @param \StructType\RelatedBrowse[] $relatedBrowse
     * @return \StructType\ExtendedMetadata
     */
    public function setRelatedBrowse(array $relatedBrowse = array())
    {
        // validation for constraint: array
        if ('' !== ($relatedBrowseArrayErrorMessage = self::validateRelatedBrowseForArrayConstraintsFromSetRelatedBrowse($relatedBrowse))) {
            throw new \InvalidArgumentException($relatedBrowseArrayErrorMessage, __LINE__);
        }
        $this->relatedBrowse = $relatedBrowse;
        return $this;
    }
    /**
     * Add item to relatedBrowse value
     * @throws \InvalidArgumentException
     * @param \StructType\RelatedBrowse $item
     * @return \StructType\ExtendedMetadata
     */
    public function addToRelatedBrowse(\StructType\RelatedBrowse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RelatedBrowse) {
            throw new \InvalidArgumentException(sprintf('The relatedBrowse property can only contain items of type \StructType\RelatedBrowse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->relatedBrowse[] = $item;
        return $this;
    }
    /**
     * Get relatedText value
     * @return \StructType\RelatedText[]|null
     */
    public function getRelatedText()
    {
        return $this->relatedText;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatedText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatedText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatedTextForArrayConstraintsFromSetRelatedText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $extendedMetadataRelatedTextItem) {
            // validation for constraint: itemType
            if (!$extendedMetadataRelatedTextItem instanceof \StructType\RelatedText) {
                $invalidValues[] = is_object($extendedMetadataRelatedTextItem) ? get_class($extendedMetadataRelatedTextItem) : sprintf('%s(%s)', gettype($extendedMetadataRelatedTextItem), var_export($extendedMetadataRelatedTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The relatedText property can only contain items of type \StructType\RelatedText, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set relatedText value
     * @throws \InvalidArgumentException
     * @param \StructType\RelatedText[] $relatedText
     * @return \StructType\ExtendedMetadata
     */
    public function setRelatedText(array $relatedText = array())
    {
        // validation for constraint: array
        if ('' !== ($relatedTextArrayErrorMessage = self::validateRelatedTextForArrayConstraintsFromSetRelatedText($relatedText))) {
            throw new \InvalidArgumentException($relatedTextArrayErrorMessage, __LINE__);
        }
        $this->relatedText = $relatedText;
        return $this;
    }
    /**
     * Add item to relatedText value
     * @throws \InvalidArgumentException
     * @param \StructType\RelatedText $item
     * @return \StructType\ExtendedMetadata
     */
    public function addToRelatedText(\StructType\RelatedText $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RelatedText) {
            throw new \InvalidArgumentException(sprintf('The relatedText property can only contain items of type \StructType\RelatedText, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->relatedText[] = $item;
        return $this;
    }
    /**
     * Get relatedPlay value
     * @return \StructType\RelatedPlay|null
     */
    public function getRelatedPlay()
    {
        return $this->relatedPlay;
    }
    /**
     * Set relatedPlay value
     * @param \StructType\RelatedPlay $relatedPlay
     * @return \StructType\ExtendedMetadata
     */
    public function setRelatedPlay(\StructType\RelatedPlay $relatedPlay = null)
    {
        $this->relatedPlay = $relatedPlay;
        return $this;
    }
    /**
     * Get relatedActions value
     * @return \StructType\RelatedActions|null
     */
    public function getRelatedActions()
    {
        return $this->relatedActions;
    }
    /**
     * Set relatedActions value
     * @param \StructType\RelatedActions $relatedActions
     * @return \StructType\ExtendedMetadata
     */
    public function setRelatedActions(\StructType\RelatedActions $relatedActions = null)
    {
        $this->relatedActions = $relatedActions;
        return $this;
    }
}
