<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customFault StructType
 * @subpackage Structs
 */
class CustomFault extends AbstractStructBase
{
    /**
     * The SonosError
     * Meta information extracted from the WSDL
     * - choice: SonosError | ExceptionInfo | refreshAuthTokenResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var int
     */
    public $SonosError;
    /**
     * The ExceptionInfo
     * Meta information extracted from the WSDL
     * - choice: SonosError | ExceptionInfo | refreshAuthTokenResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $ExceptionInfo;
    /**
     * The refreshAuthTokenResult
     * Meta information extracted from the WSDL
     * - choice: SonosError | ExceptionInfo | refreshAuthTokenResult
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\DeviceAuthTokenResult
     */
    public $refreshAuthTokenResult;
    /**
     * Constructor method for customFault
     * @uses CustomFault::setSonosError()
     * @uses CustomFault::setExceptionInfo()
     * @uses CustomFault::setRefreshAuthTokenResult()
     * @param int $sonosError
     * @param string $exceptionInfo
     * @param \StructType\DeviceAuthTokenResult $refreshAuthTokenResult
     */
    public function __construct($sonosError = null, $exceptionInfo = null, \StructType\DeviceAuthTokenResult $refreshAuthTokenResult = null)
    {
        $this
            ->setSonosError($sonosError)
            ->setExceptionInfo($exceptionInfo)
            ->setRefreshAuthTokenResult($refreshAuthTokenResult);
    }
    /**
     * Get SonosError value
     * @return int|null
     */
    public function getSonosError()
    {
        return isset($this->SonosError) ? $this->SonosError : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSonosError method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSonosError method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSonosErrorForChoiceConstraintsFromSetSonosError($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ExceptionInfo',
            'refreshAuthTokenResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SonosError can\'t be set as the property %s is already set. Only one property must be set among these properties: SonosError, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SonosError value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $sonosError
     * @return \StructType\CustomFault
     */
    public function setSonosError($sonosError = null)
    {
        // validation for constraint: int
        if (!is_null($sonosError) && !(is_int($sonosError) || ctype_digit($sonosError))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sonosError, true), gettype($sonosError)), __LINE__);
        }
        // validation for constraint: choice(SonosError, ExceptionInfo, refreshAuthTokenResult)
        if ('' !== ($sonosErrorChoiceErrorMessage = self::validateSonosErrorForChoiceConstraintsFromSetSonosError($sonosError))) {
            throw new \InvalidArgumentException($sonosErrorChoiceErrorMessage, __LINE__);
        }
        if (is_null($sonosError) || (is_array($sonosError) && empty($sonosError))) {
            unset($this->SonosError);
        } else {
            $this->SonosError = $sonosError;
        }
        return $this;
    }
    /**
     * Get ExceptionInfo value
     * @return string|null
     */
    public function getExceptionInfo()
    {
        return isset($this->ExceptionInfo) ? $this->ExceptionInfo : null;
    }
    /**
     * This method is responsible for validating the value passed to the setExceptionInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExceptionInfo method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateExceptionInfoForChoiceConstraintsFromSetExceptionInfo($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'SonosError',
            'refreshAuthTokenResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ExceptionInfo can\'t be set as the property %s is already set. Only one property must be set among these properties: ExceptionInfo, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ExceptionInfo value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $exceptionInfo
     * @return \StructType\CustomFault
     */
    public function setExceptionInfo($exceptionInfo = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionInfo) && !is_string($exceptionInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exceptionInfo, true), gettype($exceptionInfo)), __LINE__);
        }
        // validation for constraint: choice(SonosError, ExceptionInfo, refreshAuthTokenResult)
        if ('' !== ($exceptionInfoChoiceErrorMessage = self::validateExceptionInfoForChoiceConstraintsFromSetExceptionInfo($exceptionInfo))) {
            throw new \InvalidArgumentException($exceptionInfoChoiceErrorMessage, __LINE__);
        }
        if (is_null($exceptionInfo) || (is_array($exceptionInfo) && empty($exceptionInfo))) {
            unset($this->ExceptionInfo);
        } else {
            $this->ExceptionInfo = $exceptionInfo;
        }
        return $this;
    }
    /**
     * Get refreshAuthTokenResult value
     * @return \StructType\DeviceAuthTokenResult|null
     */
    public function getRefreshAuthTokenResult()
    {
        return isset($this->refreshAuthTokenResult) ? $this->refreshAuthTokenResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRefreshAuthTokenResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRefreshAuthTokenResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRefreshAuthTokenResultForChoiceConstraintsFromSetRefreshAuthTokenResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'SonosError',
            'ExceptionInfo',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property refreshAuthTokenResult can\'t be set as the property %s is already set. Only one property must be set among these properties: refreshAuthTokenResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set refreshAuthTokenResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeviceAuthTokenResult $refreshAuthTokenResult
     * @return \StructType\CustomFault
     */
    public function setRefreshAuthTokenResult(\StructType\DeviceAuthTokenResult $refreshAuthTokenResult = null)
    {
        // validation for constraint: choice(SonosError, ExceptionInfo, refreshAuthTokenResult)
        if ('' !== ($refreshAuthTokenResultChoiceErrorMessage = self::validateRefreshAuthTokenResultForChoiceConstraintsFromSetRefreshAuthTokenResult($refreshAuthTokenResult))) {
            throw new \InvalidArgumentException($refreshAuthTokenResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($refreshAuthTokenResult) || (is_array($refreshAuthTokenResult) && empty($refreshAuthTokenResult))) {
            unset($this->refreshAuthTokenResult);
        } else {
            $this->refreshAuthTokenResult = $refreshAuthTokenResult;
        }
        return $this;
    }
}
