<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for credentials StructType
 * @subpackage Structs
 */
class Credentials extends AbstractStructBase
{
    /**
     * The zonePlayerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - minOccurs: 0
     * - type: tns:id
     * @var string
     */
    public $zonePlayerId;
    /**
     * The deviceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - minOccurs: 0
     * - type: tns:id
     * @var string
     */
    public $deviceId;
    /**
     * The deviceProvider
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deviceProvider;
    /**
     * The deviceCert
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deviceCert;
    /**
     * The sessionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - choice: sessionId | login | loginToken
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxLength: 128
     * - ref: tns:sessionId
     * @var string
     */
    public $sessionId;
    /**
     * The login
     * Meta information extracted from the WSDL
     * - choice: sessionId | login | loginToken
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - ref: tns:login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - choice: sessionId | login | loginToken
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - ref: tns:loginToken
     * @var \StructType\LoginToken
     */
    public $loginToken;
    /**
     * Constructor method for credentials
     * @uses Credentials::setZonePlayerId()
     * @uses Credentials::setDeviceId()
     * @uses Credentials::setDeviceProvider()
     * @uses Credentials::setDeviceCert()
     * @uses Credentials::setSessionId()
     * @uses Credentials::setLogin()
     * @uses Credentials::setLoginToken()
     * @param string $zonePlayerId
     * @param string $deviceId
     * @param string $deviceProvider
     * @param string $deviceCert
     * @param string $sessionId
     * @param \StructType\Login $login
     * @param \StructType\LoginToken $loginToken
     */
    public function __construct($zonePlayerId = null, $deviceId = null, $deviceProvider = null, $deviceCert = null, $sessionId = null, \StructType\Login $login = null, \StructType\LoginToken $loginToken = null)
    {
        $this
            ->setZonePlayerId($zonePlayerId)
            ->setDeviceId($deviceId)
            ->setDeviceProvider($deviceProvider)
            ->setDeviceCert($deviceCert)
            ->setSessionId($sessionId)
            ->setLogin($login)
            ->setLoginToken($loginToken);
    }
    /**
     * Get zonePlayerId value
     * @return string|null
     */
    public function getZonePlayerId()
    {
        return $this->zonePlayerId;
    }
    /**
     * Set zonePlayerId value
     * @param string $zonePlayerId
     * @return \StructType\Credentials
     */
    public function setZonePlayerId($zonePlayerId = null)
    {
        // validation for constraint: string
        if (!is_null($zonePlayerId) && !is_string($zonePlayerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zonePlayerId, true), gettype($zonePlayerId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($zonePlayerId) && mb_strlen($zonePlayerId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($zonePlayerId)), __LINE__);
        }
        $this->zonePlayerId = $zonePlayerId;
        return $this;
    }
    /**
     * Get deviceId value
     * @return string|null
     */
    public function getDeviceId()
    {
        return $this->deviceId;
    }
    /**
     * Set deviceId value
     * @param string $deviceId
     * @return \StructType\Credentials
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: string
        if (!is_null($deviceId) && !is_string($deviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($deviceId) && mb_strlen($deviceId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($deviceId)), __LINE__);
        }
        $this->deviceId = $deviceId;
        return $this;
    }
    /**
     * Get deviceProvider value
     * @return string|null
     */
    public function getDeviceProvider()
    {
        return $this->deviceProvider;
    }
    /**
     * Set deviceProvider value
     * @param string $deviceProvider
     * @return \StructType\Credentials
     */
    public function setDeviceProvider($deviceProvider = null)
    {
        // validation for constraint: string
        if (!is_null($deviceProvider) && !is_string($deviceProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceProvider, true), gettype($deviceProvider)), __LINE__);
        }
        $this->deviceProvider = $deviceProvider;
        return $this;
    }
    /**
     * Get deviceCert value
     * @return string|null
     */
    public function getDeviceCert()
    {
        return $this->deviceCert;
    }
    /**
     * Set deviceCert value
     * @param string $deviceCert
     * @return \StructType\Credentials
     */
    public function setDeviceCert($deviceCert = null)
    {
        // validation for constraint: string
        if (!is_null($deviceCert) && !is_string($deviceCert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceCert, true), gettype($deviceCert)), __LINE__);
        }
        $this->deviceCert = $deviceCert;
        return $this;
    }
    /**
     * Get sessionId value
     * @return string|null
     */
    public function getSessionId()
    {
        return isset($this->sessionId) ? $this->sessionId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSessionId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSessionId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSessionIdForChoiceConstraintsFromSetSessionId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'login',
            'loginToken',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property sessionId can\'t be set as the property %s is already set. Only one property must be set among these properties: sessionId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set sessionId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $sessionId
     * @return \StructType\Credentials
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionId, true), gettype($sessionId)), __LINE__);
        }
        // validation for constraint: choice(sessionId, login, loginToken)
        if ('' !== ($sessionIdChoiceErrorMessage = self::validateSessionIdForChoiceConstraintsFromSetSessionId($sessionId))) {
            throw new \InvalidArgumentException($sessionIdChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($sessionId) && mb_strlen($sessionId) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($sessionId)), __LINE__);
        }
        if (is_null($sessionId) || (is_array($sessionId) && empty($sessionId))) {
            unset($this->sessionId);
        } else {
            $this->sessionId = $sessionId;
        }
        return $this;
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return isset($this->login) ? $this->login : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLogin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLogin method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLoginForChoiceConstraintsFromSetLogin($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'sessionId',
            'loginToken',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property login can\'t be set as the property %s is already set. Only one property must be set among these properties: login, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set login value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Login $login
     * @return \StructType\Credentials
     */
    public function setLogin(\StructType\Login $login = null)
    {
        // validation for constraint: choice(sessionId, login, loginToken)
        if ('' !== ($loginChoiceErrorMessage = self::validateLoginForChoiceConstraintsFromSetLogin($login))) {
            throw new \InvalidArgumentException($loginChoiceErrorMessage, __LINE__);
        }
        if (is_null($login) || (is_array($login) && empty($login))) {
            unset($this->login);
        } else {
            $this->login = $login;
        }
        return $this;
    }
    /**
     * Get loginToken value
     * @return \StructType\LoginToken|null
     */
    public function getLoginToken()
    {
        return isset($this->loginToken) ? $this->loginToken : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLoginToken method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoginToken method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLoginTokenForChoiceConstraintsFromSetLoginToken($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'sessionId',
            'login',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property loginToken can\'t be set as the property %s is already set. Only one property must be set among these properties: loginToken, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set loginToken value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LoginToken $loginToken
     * @return \StructType\Credentials
     */
    public function setLoginToken(\StructType\LoginToken $loginToken = null)
    {
        // validation for constraint: choice(sessionId, login, loginToken)
        if ('' !== ($loginTokenChoiceErrorMessage = self::validateLoginTokenForChoiceConstraintsFromSetLoginToken($loginToken))) {
            throw new \InvalidArgumentException($loginTokenChoiceErrorMessage, __LINE__);
        }
        if (is_null($loginToken) || (is_array($loginToken) && empty($loginToken))) {
            unset($this->loginToken);
        } else {
            $this->loginToken = $loginToken;
        }
        return $this;
    }
}
