<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createItemResponse StructType
 * @subpackage Structs
 */
class CreateItemResponse extends AbstractStructBase
{
    /**
     * The createItemResult
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - type: tns:id
     * @var string
     */
    public $createItemResult;
    /**
     * Constructor method for createItemResponse
     * @uses CreateItemResponse::setCreateItemResult()
     * @param string $createItemResult
     */
    public function __construct($createItemResult = null)
    {
        $this
            ->setCreateItemResult($createItemResult);
    }
    /**
     * Get createItemResult value
     * @return string|null
     */
    public function getCreateItemResult()
    {
        return $this->createItemResult;
    }
    /**
     * Set createItemResult value
     * @param string $createItemResult
     * @return \StructType\CreateItemResponse
     */
    public function setCreateItemResult($createItemResult = null)
    {
        // validation for constraint: string
        if (!is_null($createItemResult) && !is_string($createItemResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createItemResult, true), gettype($createItemResult)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($createItemResult) && mb_strlen($createItemResult) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($createItemResult)), __LINE__);
        }
        $this->createItemResult = $createItemResult;
        return $this;
    }
}
