<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createContainer StructType
 * @subpackage Structs
 */
class CreateContainer extends AbstractStructBase
{
    /**
     * The containerType
     * @var string
     */
    public $containerType;
    /**
     * The title
     * @var string
     */
    public $title;
    /**
     * The parentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - type: tns:id
     * @var string
     */
    public $parentId;
    /**
     * The seedId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - type: tns:id
     * @var string
     */
    public $seedId;
    /**
     * Constructor method for createContainer
     * @uses CreateContainer::setContainerType()
     * @uses CreateContainer::setTitle()
     * @uses CreateContainer::setParentId()
     * @uses CreateContainer::setSeedId()
     * @param string $containerType
     * @param string $title
     * @param string $parentId
     * @param string $seedId
     */
    public function __construct($containerType = null, $title = null, $parentId = null, $seedId = null)
    {
        $this
            ->setContainerType($containerType)
            ->setTitle($title)
            ->setParentId($parentId)
            ->setSeedId($seedId);
    }
    /**
     * Get containerType value
     * @return string|null
     */
    public function getContainerType()
    {
        return $this->containerType;
    }
    /**
     * Set containerType value
     * @param string $containerType
     * @return \StructType\CreateContainer
     */
    public function setContainerType($containerType = null)
    {
        // validation for constraint: string
        if (!is_null($containerType) && !is_string($containerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($containerType, true), gettype($containerType)), __LINE__);
        }
        $this->containerType = $containerType;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\CreateContainer
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get parentId value
     * @return string|null
     */
    public function getParentId()
    {
        return $this->parentId;
    }
    /**
     * Set parentId value
     * @param string $parentId
     * @return \StructType\CreateContainer
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: string
        if (!is_null($parentId) && !is_string($parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentId, true), gettype($parentId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($parentId) && mb_strlen($parentId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($parentId)), __LINE__);
        }
        $this->parentId = $parentId;
        return $this;
    }
    /**
     * Get seedId value
     * @return string|null
     */
    public function getSeedId()
    {
        return $this->seedId;
    }
    /**
     * Set seedId value
     * @param string $seedId
     * @return \StructType\CreateContainer
     */
    public function setSeedId($seedId = null)
    {
        // validation for constraint: string
        if (!is_null($seedId) && !is_string($seedId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seedId, true), gettype($seedId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($seedId) && mb_strlen($seedId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($seedId)), __LINE__);
        }
        $this->seedId = $seedId;
        return $this;
    }
}
