<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for context StructType
 * Meta information extracted from the WSDL
 * - documentation: Extensibility point to add new context header information. Please refer to Sonos documentation for details
 * @subpackage Structs
 */
class Context extends AbstractStructBase
{
    /**
     * The timeZone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $timeZone;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for context
     * @uses Context::setTimeZone()
     * @uses Context::setAny()
     * @param string $timeZone
     * @param \DOMDocument $any
     */
    public function __construct($timeZone = null, \DOMDocument $any = null)
    {
        $this
            ->setTimeZone($timeZone)
            ->setAny($any);
    }
    /**
     * Get timeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * Set timeZone value
     * @param string $timeZone
     * @return \StructType\Context
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: string
        if (!is_null($timeZone) && !is_string($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeZone, true), gettype($timeZone)), __LINE__);
        }
        $this->timeZone = $timeZone;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\Context
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
