<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for callToActionInfo StructType
 * @subpackage Structs
 */
class CallToActionInfo extends AbstractStructBase
{
    /**
     * The messageStringId
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $messageStringId;
    /**
     * The url
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 2048
     * - minOccurs: 0
     * @var string
     */
    public $url;
    /**
     * The urlStringId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $urlStringId;
    /**
     * Constructor method for callToActionInfo
     * @uses CallToActionInfo::setMessageStringId()
     * @uses CallToActionInfo::setUrl()
     * @uses CallToActionInfo::setUrlStringId()
     * @param string $messageStringId
     * @param string $url
     * @param string $urlStringId
     */
    public function __construct($messageStringId = null, $url = null, $urlStringId = null)
    {
        $this
            ->setMessageStringId($messageStringId)
            ->setUrl($url)
            ->setUrlStringId($urlStringId);
    }
    /**
     * Get messageStringId value
     * @return string
     */
    public function getMessageStringId()
    {
        return $this->messageStringId;
    }
    /**
     * Set messageStringId value
     * @param string $messageStringId
     * @return \StructType\CallToActionInfo
     */
    public function setMessageStringId($messageStringId = null)
    {
        // validation for constraint: string
        if (!is_null($messageStringId) && !is_string($messageStringId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageStringId, true), gettype($messageStringId)), __LINE__);
        }
        $this->messageStringId = $messageStringId;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \StructType\CallToActionInfo
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        // validation for constraint: maxLength(2048)
        if (!is_null($url) && mb_strlen($url) > 2048) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2048', mb_strlen($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get urlStringId value
     * @return string|null
     */
    public function getUrlStringId()
    {
        return $this->urlStringId;
    }
    /**
     * Set urlStringId value
     * @param string $urlStringId
     * @return \StructType\CallToActionInfo
     */
    public function setUrlStringId($urlStringId = null)
    {
        // validation for constraint: string
        if (!is_null($urlStringId) && !is_string($urlStringId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlStringId, true), gettype($urlStringId)), __LINE__);
        }
        $this->urlStringId = $urlStringId;
        return $this;
    }
}
